/* *********************************************************************
   *                                                                   *
   *  NAME     : Mariusz Zaczek          PROGRAM : MP4                 *
   *  NET ID   : zaczek                  COURSE  : CS318 - Fall 1999   *
   *  DUE DATE : Nov. 5,1999                                           *
   *                                                                   *
   *  PURPOSE  : The purpose of this MP is to learn more about Spline  *
   *              in general. The main focus in this mp is on the      *
   *              cubic periodic spline.                               *
   *                                                                   *
   *  INPUTS   : MOUSE & KEYBOARD INPUTS:                              *
   *             Left Mouse Button  - Enters the control points.       *
   *                                   ( Maximum of 50 control points) *
   *             <backspace key>    - Erases the one point from the    *
   *                                   array of points...starting with *
   *                                   the last one first.             *
   *             <spacebar key>     - Clears all points and splines    *
   *             q or Q             - used to quit the program         *
   *                                                                   *
   ********************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <GL/glut.h>

/* Defines */
#define TRUE  1
#define FALSE 0

/* Global variables for screen width and height*/
GLint WinWidth = 600;
GLint WinHeight = 600;

/* Point structure containing two integer values corresponding to the
   x and y coordinate values. */
typedef struct
{
  GLint x,y;
} PointsInt;  

/* Point structure containing two float values. */
typedef struct
{
  GLfloat x,y;
} PointsFloat;

/* 4 value Vector structure used to store the a,b,c,d coefficients */
typedef struct
{
  GLfloat a,b,c,d;
} Vector;

PointsInt Pts[50];      /* Array of control points */
GLint numPts = 0;     /* number of points entered */

/* Precalculated delta value.... */
GLfloat delta_1 = 0.025,      /* 1/40 */
        delta_2 = 0.000625,
        delta_3 = 0.000015625;

/* Mb Matrix specified in the book on page 341. */
GLfloat Mb[16] = {  -0.166666667,  0.5000, -0.5000,  0.166666667,
                     0.500000000, -1.0000,  0.5000,  0.0000,
                    -0.500000000,  0.0000,  0.5000,  0.0000,
                     0.166666667,  0.666666667,  0.166666667,  0.0000 };

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    MatrixVectorMultiply                         +
   +                                                            +
   +  Purpose: To multiply a Matrix and a Vector which results  +
   +            in another vector.                              +
   +                                                            +
   +  Inputs: one, two, three & four : Point used as the P0,    + 
   +             P1, P2 and P3 values used in the matrix/vector +
   +             multiplication.                                +
   +                                                            +   
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
Vector MatrixVectorMultiply(GLint one, GLint two, GLint three, GLint four)
{
  Vector coefficient;
  
  coefficient.a =  Mb[0]*one +  Mb[1]*two +  Mb[2]*three +  Mb[3]*four;
  coefficient.b =  Mb[4]*one +  Mb[5]*two +  Mb[6]*three +  Mb[7]*four;
  coefficient.c =  Mb[8]*one +  Mb[9]*two + Mb[10]*three + Mb[11]*four;
  coefficient.d = Mb[12]*one + Mb[13]*two + Mb[14]*three + Mb[15]*four;

  return coefficient;
}

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    DrawLines                                    +
   +                                                            +
   +  Purpose: To draw the control lines for the spline.        +
   +                                                            +
   +  Inputs: none                                              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void DrawLines(void)
{
  GLint i = 0;

  glColor3f(0.0, 0.0, 1.0);  /* BLUE */

  /* Draw Points of size 5 */
  glPointSize(5.0);

  glBegin(GL_POINTS);
    for ( i=0 ; i<numPts ; i++ )
      glVertex2d(Pts[i].x, Pts[i].y);
  glEnd();  
  
  /* Draw connecting lines */
  glPointSize(1.0);
 
  glBegin(GL_LINE_STRIP);
    for ( i=0 ; i<numPts ; i++ )
      glVertex2d(Pts[i].x, Pts[i].y);
  glEnd();

}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    DrawSplines                                  +  
   +                                                            +
   +  Purpose: To generate the splines from the given control   +
   +             points.                                        +
   +                                                            +
   +  Inputs: none                                              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void DrawSplines(void) 
{  
  GLint i = 0, j = 0;
  GLfloat Dx, Dx2, Dx3, Dy, Dy2, Dy3;
  Vector Xvals, Yvals;
  PointsFloat first, second;

  glColor3f(1.0, 1.0, 0.0);  /* YELLOW */
 
  /* Loop through all control points.. not using first 3. */
  for ( i=3 ; i<numPts ; i++ )
  {
    /* Determine the ax,bx,cx,dx and ay,by,cy,dy coefficients */
    Xvals = MatrixVectorMultiply(Pts[i-3].x, Pts[i-2].x, Pts[i-1].x, Pts[i].x);
    Yvals = MatrixVectorMultiply(Pts[i-3].y, Pts[i-2].y, Pts[i-1].y, Pts[i].y);

    /* Store first point */
    first.x = Xvals.d; 
    first.y = Yvals.d;

    /* Update the delta X, X^2 and X^3 values...for forward difference method */ 
     Dx =   Xvals.a*delta_3 +   Xvals.b*delta_2 + Xvals.c*delta_1;
     Dy =   Yvals.a*delta_3 +   Yvals.b*delta_2 + Yvals.c*delta_1;
    Dx2 = 6*Xvals.a*delta_3 + 2*Xvals.b*delta_2;
    Dy2 = 6*Yvals.a*delta_3 + 2*Yvals.b*delta_2;
    Dx3 = 6*Xvals.a*delta_3;
    Dy3 = 6*Yvals.a*delta_3;

    /* Loop through the number of segments for each spline...chose 40 */
    for ( j=0 ; j<40 ; j++ )
    {
      /* Calculate and Store second point of small delta segment of spline */
      second.x = first.x + Dx;
      second.y = first.y + Dy;
  
      /* Update delta values */
       Dx += Dx2; 
       Dy += Dy2;
      Dx2 += Dx3;
      Dy2 += Dy3;
       
      /* Draw small portion (1/40 th) of spline */
      glBegin(GL_LINE_STRIP);
        glVertex2f( first.x,  first.y);
        glVertex2f(second.x, second.y);
      glEnd();
      
      /* Make second point now the first point for next spline segment */
      first.x = second.x;
      first.y = second.y;
    }
  }
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    reshape                                      +
   +                                                            +
   +  Purpose: This function allows the screen to be resized    +
   +            but the line draw still appears in its original +
   +            position and length.                            +
   +                                                            +
   +  Inputs: w and h - width and height of window              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void reshape (int w, int h)
{
  glViewport (0, 0, (GLsizei) w, (GLsizei) h);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  gluOrtho2D (0.0, (GLdouble) w,(GLdouble) h, 0.0);
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    SetCameraPosition                            +
   +                                                            +
   +  Purpose: This function sets the postion of the camera     +
   +                                                            +
   +  Inputs: none                                              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void SetCameraPosition(void)
{
  /* Set the viewing transformation */
  glMatrixMode(GL_PROJECTION); 
  glLoadIdentity();
  gluOrtho2D(0.0,(GLdouble)WinWidth+1.0,(GLdouble)WinHeight+1.0,0.0);
  glMatrixMode(GL_MODELVIEW);
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    init                                         +
   +                                                            +
   +  Purpose: This function clears the colors and initializes  +
   +            the shade model.                                +
   +                                                            +
   +  Inputs: none                                              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */   
void init(void)
{
  glClearColor(0.0, 0.0, 0.0, 0.0);
  glShadeModel(GL_FLAT);
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    display                                      +
   +                                                            +
   +  Purpose: To display the lines, clipping box and the       +
   +           clipped lines.                                   +
   +                                                            +
   +  Inputs: none                                              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void display(void)
{
  glClear(GL_COLOR_BUFFER_BIT);
  glColor3f(1.0,1.0,1.0);

  /* If some points have been entered then display control lines. */
  if ( numPts > 0 )
    DrawLines();

  /* If at least 4 points have been drawn then draw the splines */
  if ( numPts > 3 )
    DrawSplines();

  glFlush(); 
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    KeyPress                                     +
   +                                                            +
   +  Purpose: This function will check to see if the key       +
   +            pressed is a q (or Q). If so, then the program  +
   +            will terminate gracefully.                      +
   +                                                            +
   +  Inputs: Key (unsigned char) - Key pressed.                +
   +          X (int) - x location of mouse pointer.            +
   +          Y (int) - y location of mouse pointer.            +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void KeyPress(unsigned char Key, int X, int Y)
{
  if (toupper(Key) == 'Q')
    exit(0);
 
  /* If backspace or space key were hit then decrease points by
     one or set number of points to zero. */
  if ( Key == '\b' )
  {
    if ( numPts != 0 )
      numPts--;
  }
  else if ( Key == ' ' )
    numPts = 0;

  glutPostRedisplay();
}
 
 
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    MouseButtonPressed                           +
   +                                                            +
   +  Purpose: To capture the input of endpoint for a line.     +
   +           On the depression of the left mouse button the   +
   +           current cursor position is used to capture the   +
   +           coordinates at the current point which are used  +
   +           to define the first or second endpoint.          +
   +                                                            +
   +  Inputs: Button - determines which button is selected.     +
   +          State - determines if button is pressed/released  +
   +          X,Y - coordinates of current cursor               +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void MouseButtonPressed(int Button, int State, int X, int Y)
{
  if (State == GLUT_DOWN)
    if (Button == GLUT_LEFT_BUTTON)
      if ( numPts < 50 )  /* While 50 points have not been entered */
      {
        Pts[numPts].x = X;     Pts[numPts].y = Y;
        
        numPts++;
      }

  glutPostRedisplay();
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    main                                         +
   +                                                            +
   +  Purpose: This is the main function of mp4. Most of the    +
   +            initialization of the display is done here and  +
   +            functions for events are invoked here.          +
   +                                                            +
   +  Inputs: none.                                             +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
int main(int argc, char **argv)
{
  /* Display quit procedure. */
  printf("CS318 - MP4 - Cubic Periodic B-Splines using Forward Differences\n");
  printf("INPUTS:\n");
  printf("Left Mouse Button   - Enter up to 50 Points\n");
  printf("<Backspace>         - Erases previous point\n");
  printf("<Space>             - Clears all points\n");
  printf("'q' or 'Q'          - Quit Program\n");

  /* Initialize window. */
  glutInit(&argc, argv);
  glutInitWindowSize(WinWidth, WinWidth);
  glutInitWindowPosition(100, 100);
  glutCreateWindow("MP4: Cubic Periodic B-Splines using Forward Differences");
  init();

  /* Define camera position. */
  SetCameraPosition();

  /* Call display function and enter main loop. */
  glutDisplayFunc(display);
  glutMouseFunc(MouseButtonPressed);
  glutKeyboardFunc(KeyPress);
  glutReshapeFunc(reshape);
  glutMainLoop();

  return 0;
}

