/* *********************************************************************
   *                                                                   *
   *  NAME     : Mariusz Zaczek          PROGRAM : MP3                 *
   *  NET ID   : zaczek                  COURSE  : CS318 - Fall 1999   *
   *  DUE DATE : Oct. 22,1999                                          *
   *                                                                   *
   *  PURPOSE  : The purpose of this MP is to demonstrate the          *
   *             NICHOLL-LEE-NICHOLL Clipping Algorithm.               *
   *             Lines are draw on the screen in green and a clipping  *
   *             box is used to define the clipping region. The        *
   *             clipped lines are draw in red overlapping the         *
   *             original lines.                                       *
   *                                                                   *
   *  INPUTS   : MOUSE & KEYBOARD INPUTS:                              *
   *             Left Mouse Button - allows the user to enter 40       *
   *                   endpoints for a maximum of 20 lines.            *
   *             Right Mouse Button - allows the user to enter 2       *
   *                   endpoints to define the clipping box.           *
   *             <backspace key> - Hitting theis key clear all lines.  *
   *             q or Q - used to quit the program gracefully          *
   *                                                                   *
   ********************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <GL/glut.h>

/* Defines */
#define TRUE  1
#define FALSE 0
#define LARGE_NUMBER 99999999

/* Global variables for screen width and height*/
int WinWidth = 600;
int WinHeight = 600;

/* Point structure containing two integer values corresponding to the
   x and y coordinate values. */
typedef struct
{
  int x,y;
} Points;  

Points	Pts[40];       /* Array of points used to draw lines */
Points  ClipPts[40];    /* Array of new points after lines are clipped */
Points  LeftPoint = {0,0};   /* Left Point of clipping box */
Points  RightPoint = {0,0};  /* Right Point of clipping box...x2 > x1 */

int numPts = 0;       /* number of points entered for the lines */
int numRecPts = 0;   /* Number of points entered so far for the 
                            clipping box *.

/* The max and min values of the clipping box */
int xmin=0, ymin=0, xmax=0, ymax=0;

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    FindSlope                                    +
   +                                                            +
   +  Purpose: This function the calculates the slope of a line +
   +           give both endpoints (x and y values for each)    +
   +                                                            +
   +  Inputs: int  firstX - x value of 1st point                +
   +               firstY - y value of 1st point                +
   +              secondX - x value of 2nd point                +
   +              secondY - y value of 2nd point                +
   +                                                            +   
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
double FindSlope(int firstX, int firstY, int secondX, int secondY)
{
  if ( (secondX - firstX) == 0 )
    return LARGE_NUMBER;
  else
    return (double)(secondY - firstY) / (secondX - firstX);
}

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++   
   +                                                            +   
   +  Function:    InsideRect                                   +   
   +                                                            +   
   +  Purpose: This function determines if the _testpt_ points  +
   +            is inside or outside the clipping box.          +
   +                                                            +
   +  Inputs: Points testpt - The point which is tested to see  +                                               
   +                          if it is inside the clipping box. +
   +                                                            +   
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
int InsideRect(Points testpt)
{
  if ( (testpt.x >= xmin) && (testpt.x <= xmax) &&
       (testpt.y >= ymin) && (testpt.y <= ymax) )
    return 1;
  else
    return 0;
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    FindCorners                                  +
   +                                                            +
   +  Purpose: This function determines the max and min values  +
   +           for all the corners.                             +
   +                                                            +
   +  Inputs: none                                              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void FindCorners()
{
  xmin = LeftPoint.x;
  xmax = RightPoint.x;

  if ( LeftPoint.y <= RightPoint.y )
  { 
    ymin = LeftPoint.y;
    ymax = RightPoint.y;
  }
  else
  {
    ymin = RightPoint.y;
    ymax = LeftPoint.y;
  }
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    Clipping                                     +
   +                                                            +
   +  Purpose: This function performs all the calculation for   +
   +           the clipping of lines...clipped lines are stored +
   +           in a ClipPts array...lines that are outside      +
   +           the clipping box have a -1 value for the first   +
   +           points x value.                                  +
   +                                                            +
   +  Inputs: none                                              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Clipping()
{
  int i = 0, j = 0;
  double slope = 0;

  /* Clear ClipPts array */
  for ( i=0 ; i<numPts ; i++ )
  { 
    ClipPts[i].x = -1;
    ClipPts[i].y = 0;
  }

  for ( i=0,j=0; i<numPts-1 ; i+=2, j++ )
  {
    if ( (Pts[i].x > xmax) || (Pts[i+1].x < xmin) )
    {
        ClipPts[i].x = -1;
        ClipPts[i].y = 0;
      ClipPts[i+1].x = 0;
      ClipPts[i+1].y = 0;
    }
    else
    {
      if ( InsideRect(Pts[i]) )      /* P1 inside box */
      {
        ClipPts[i].x =   Pts[i].x;
        ClipPts[i].y =   Pts[i].y;

        if ( InsideRect(Pts[i+1]) )  /* P2 inside box...clip entire line */
        {
          ClipPts[i+1].x = Pts[i+1].x;
          ClipPts[i+1].y = Pts[i+1].y;
        }
        else /* P2 Outside box...clip at boundary */
        {
          slope = FindSlope( Pts[i].x,Pts[i].y,Pts[i+1].x,Pts[i+1].y );

          if ( slope < FindSlope( Pts[i].x,Pts[i].y,xmax,ymin) )
          {
            /* P2 is at top of box */
            ClipPts[i+1].x = Pts[i].x + (int)((ymin - Pts[i].y)/slope);
            ClipPts[i+1].y = ymin;
          }
          else if ( slope > FindSlope( Pts[i].x, Pts[i].y,xmax,ymax) )
          {
            /* P2 is at bottom of box */
            ClipPts[i+1].x = Pts[i].x + (int)((ymax - Pts[i].y)/slope);
            ClipPts[i+1].y = ymax;
          }
          else
          {
            /* P2 is to right of box */
            ClipPts[i+1].x = xmax;
            ClipPts[i+1].y = Pts[i].y + (int)(slope*(xmax - Pts[i].x));
          }
        }
      }
      else  /* P1 outside box */
      {
        slope = FindSlope( Pts[i].x,Pts[i].y,Pts[i+1].x,Pts[i+1].y ); 
                     
        if ( Pts[i].x > xmin )   /* If P1 is to the right of the LEFT Boundary */
        {
          /* P1 Is in middle column section but NOT in box */
          if ( Pts[i].y < ymin ) /* P1 is on top */
          {
            if ( Pts[i+1].y < ymin )
            { 
                ClipPts[i].x = -1;
                ClipPts[i].y = 0;
              ClipPts[i+1].x = 0;
              ClipPts[i+1].y = 0;
            }
            else if ( InsideRect(Pts[i+1]) )/* P2 is in box */
            {
                ClipPts[i].x = Pts[i+1].x + (int)((ymin - Pts[i+1].y)/slope);
                ClipPts[i].y = ymin;
              ClipPts[i+1].x = Pts[i+1].x;
              ClipPts[i+1].y = Pts[i+1].y;
            }
            else if ( slope < FindSlope( Pts[i].x,Pts[i].y,xmax,ymin) )
            {
                ClipPts[i].x = -1;
                ClipPts[i].y = 0;
              ClipPts[i+1].x = 0;
              ClipPts[i+1].y = 0;
            }
            else if ( slope > FindSlope( Pts[i].x,Pts[i].y,xmax,ymax) )
            {
                ClipPts[i].x = Pts[i].x + (int)((ymin - Pts[i].y)/slope);
                ClipPts[i].y = ymin;
              ClipPts[i+1].x = Pts[i+1].x - (int)((Pts[i+1].y - ymax)/slope);
              ClipPts[i+1].y = ymax;
            }
            else  /* P2 is to the right of the RIGHT boundary */
            {
                ClipPts[i].x = Pts[i].x + (int)((ymin - Pts[i].y)/slope);
                ClipPts[i].y = ymin;
              ClipPts[i+1].x = xmax;
              ClipPts[i+1].y = Pts[i+1].y - (int)(slope*(Pts[i+1].x - xmax));
            }
          }
          else  /* P1 BOTTOM */
          {
            if ( Pts[i+1].y > ymax )
            {
                ClipPts[i].x = -1;
                ClipPts[i].y = 0;
              ClipPts[i+1].x = 0;
              ClipPts[i+1].y = 0;
            }
            else if ( InsideRect(Pts[i+1]) )/* P2 is in box */
            {
                ClipPts[i].x = Pts[i].x + (int)((ymax - Pts[i].y)/slope);
                ClipPts[i].y = ymax;
              ClipPts[i+1].x = Pts[i+1].x;
              ClipPts[i+1].y = Pts[i+1].y;
            }
            else if ( slope > FindSlope( Pts[i].x,Pts[i].y,xmax,ymax) )
            {
                ClipPts[i].x = -1;
                ClipPts[i].y = 0;
              ClipPts[i+1].x = 0;
              ClipPts[i+1].y = 0;
            }
            else if ( slope < FindSlope( Pts[i].x, Pts[i].y, xmax,ymin) )
            {
                ClipPts[i].x = Pts[i].x + (int)((ymin - Pts[i].y)/slope);
                ClipPts[i].y = ymin;
              ClipPts[i+1].x = Pts[i+1].x - (int)((Pts[i+1].y - ymax)/slope);
              ClipPts[i+1].y = ymax;
            }
            else  /* P2 is to the right of the RIGHT boundary */ 
            {
                ClipPts[i].x = Pts[i].x + (int)((ymax - Pts[i].y)/slope);
                ClipPts[i].y = ymax;
              ClipPts[i+1].x = xmax;
              ClipPts[i+1].y = Pts[i+1].y - (int)(slope*(Pts[i+1].x - xmax));
            }
          }
        }
        else  /* P1 is left of boundary box */
        {
          slope = FindSlope( Pts[i].x,Pts[i].y,Pts[i+1].x,Pts[i+1].y );
          /* P1 is left of the BOX */
          
          if ( Pts[i].y < ymin )  /* P1 is TOP LEFT corner */
          {
            if ( Pts[i+1].y < ymin )
            {
             /* P2 is below minimum y value of box*/
             /* If P2 is left of the boundary has already 
                 been taken care of at start of code */
                ClipPts[i].x = -1;
                ClipPts[i].y = 0;
              ClipPts[i+1].x = 0;
              ClipPts[i+1].y = 0;
            }
            else  /* P2 is either inside Rectangle or Past it */
            {
              /* Check where P1 is in corner case */
              if ( FindSlope(Pts[i].x,Pts[i].y,xmin,ymin) >=
		   FindSlope(xmin,ymin,xmax,ymax) )
              {
                /* P1 is in upper region ...above x=y line */
                if ( slope < FindSlope(Pts[i].x,Pts[i].y,xmax,ymin) ||
                     slope > FindSlope(Pts[i].x,Pts[i].y,xmin,ymax) )
                {
                    ClipPts[i].x = -1;
                    ClipPts[i].y = 0;
                  ClipPts[i+1].x = 0;
                  ClipPts[i+1].y = 0;
                }
                else if ( slope > FindSlope(Pts[i].x,Pts[i].y,xmin,ymin) )
                {
                  ClipPts[i].x = xmin;                  
                  ClipPts[i].y = Pts[i].y + (int)(slope*(xmin - Pts[i].x));

                  if ( InsideRect(Pts[i+1]) )
                  {
                    ClipPts[i+1].x = Pts[i+1].x;
                    ClipPts[i+1].y = Pts[i+1].y;
                  }
                  else
                  {
                    ClipPts[i+1].x = Pts[i+1].x - (int)((Pts[i+1].y-ymax)/slope);
                    ClipPts[i+1].y = ymax;
                  }
                }
                else if ( slope < FindSlope(Pts[i].x,Pts[i].y,xmax,ymax) )
                {
                  ClipPts[i].x = Pts[i].x + (int)((ymin - Pts[i].y)/slope);
                  ClipPts[i].y = ymin;
        
                  if ( InsideRect(Pts[i+1]) )
                  {       
                    ClipPts[i+1].x = Pts[i+1].x;
                    ClipPts[i+1].y = Pts[i+1].y;
                  }
                  else
                  {
                    ClipPts[i+1].x = xmax;
                    ClipPts[i+1].y = Pts[i+1].y - (int)(slope*(Pts[i+1].x-xmax));
                  }
                }
                else 
                {
                  ClipPts[i].x = Pts[i].x + (int)((ymin - Pts[i].y)/slope);
                  ClipPts[i].y = ymin;

                  if ( InsideRect(Pts[i+1]) )
                  {
                    ClipPts[i+1].x = Pts[i+1].x;
                    ClipPts[i+1].y = Pts[i+1].y;
                  }
                  else
                  {   
                    ClipPts[i+1].x = Pts[i+1].x - (int)((Pts[i+1].y-ymax)/slope);
                    ClipPts[i+1].y = ymax;
                  }
                }
              }
              else
              {
                /* P1 is in lower region ...below x=y line */
                if ( slope < FindSlope(Pts[i].x,Pts[i].y,xmax,ymin) ||
                     slope > FindSlope(Pts[i].x,Pts[i].y,xmin,ymax) )
                {  
                    ClipPts[i].x = -1;
                    ClipPts[i].y = 0;
                  ClipPts[i+1].x = 0;
                  ClipPts[i+1].y = 0;
                }  
                else if ( slope < FindSlope(Pts[i].x,Pts[i].y,xmin,ymin) )
                {
                  ClipPts[i].x = Pts[i].x + (int)((ymin-Pts[i].y)/slope);
                  ClipPts[i].y = ymin;
                
                  if ( InsideRect(Pts[i+1]) )
                  {
                    ClipPts[i+1].x = Pts[i+1].x;
                    ClipPts[i+1].y = Pts[i+1].y;
                  }
                  else
                  {
                    ClipPts[i+1].x = xmax;
                    ClipPts[i+1].y = Pts[i+1].y - (int)(slope*(Pts[i+1].x-xmax));
                  }   
                }
                else if ( slope > FindSlope(Pts[i].x,Pts[i].y,xmax,ymax) )
                {
                  ClipPts[i].x = xmin;
                  ClipPts[i].y = Pts[i].y + (int)(slope*(xmin-Pts[i].x));
               
                  if ( InsideRect(Pts[i+1]) )
                  {
                    ClipPts[i+1].x = Pts[i+1].x;  
                    ClipPts[i+1].y = Pts[i+1].y;
                  }
                  else
                  {
                    ClipPts[i+1].x = Pts[i+1].x + (int)((ymax-Pts[i+1].y)/slope); 
                    ClipPts[i+1].y = ymax;
                  }
                }
                else 
                {
                  ClipPts[i].x = xmin; 
                  ClipPts[i].y = Pts[i].y + (int)(slope*(xmin-Pts[i].x));
            
                  if ( InsideRect(Pts[i+1]) )
                  {
                    ClipPts[i+1].x = Pts[i+1].x;
                    ClipPts[i+1].y = Pts[i+1].y;
                  }
                  else
                  {
                    ClipPts[i+1].x = xmax;
                    ClipPts[i+1].y = Pts[i+1].y - (int)(slope*(Pts[i+1].x-xmax));
                  }
                }  
              }
            }
          }
          else if ( Pts[i].y > ymax )  /* P1 is BOTTOM LEFT corner */
          {
           if ( Pts[i+1].y > ymax )
            {
             /* P2 is above the max y value of box*/
             /* If P2 is left of the boundary has 
                already been taken care of at start of code */
                ClipPts[i].x = -1;
                ClipPts[i].y = 0;
              ClipPts[i+1].x = 0;
              ClipPts[i+1].y = 0;
            }
            else  /* P2 is either inside Rectangle or Past it */
            {
              /* Check where P1 is in corner case */
              if ( FindSlope(Pts[i].x,Pts[i].y,xmin,ymax) <= 
                   FindSlope(xmin,ymax,xmax,ymin) )
              {
                /* P1 is in upper region ...above x=-y line */
                if ( slope > FindSlope(Pts[i].x,Pts[i].y,xmax,ymax) ||
                     slope < FindSlope(Pts[i].x,Pts[i].y,xmin,ymin) )
                {
                    ClipPts[i].x = -1;
                    ClipPts[i].y = 0;
                  ClipPts[i+1].x = 0; 
                  ClipPts[i+1].y = 0;
                }
                else if ( slope > FindSlope(Pts[i].x,Pts[i].y,xmax,ymin) )
                {
                  ClipPts[i].x = Pts[i].x + (int)((ymax-Pts[i].y)/slope);
                  ClipPts[i].y = ymax;
              
                  if ( InsideRect(Pts[i+1]) )
                  {
                    ClipPts[i+1].x = Pts[i+1].x;
                    ClipPts[i+1].y = Pts[i+1].y;
                  }
                  else
                  {
                    ClipPts[i+1].x = xmax;
                    ClipPts[i+1].y = Pts[i+1].y - (int)(slope*(Pts[i+1].x-xmax));
                  }
                }
                else if ( slope < FindSlope(Pts[i].x,Pts[i].y,xmin,ymax) )
                {
                  ClipPts[i].x = xmin;
                  ClipPts[i].y = Pts[i].y - (int)(slope*(Pts[i].x-xmin));
                 
                  if ( InsideRect(Pts[i+1]) )
                  {
                    ClipPts[i+1].x = Pts[i+1].x;
                    ClipPts[i+1].y = Pts[i+1].y;
                  }
                  else
                  {
                    ClipPts[i+1].x = Pts[i+1].x - (int)((Pts[i+1].y-ymin)/slope);
                    ClipPts[i+1].y = ymin;
                  }
                }
                else
                {
                  ClipPts[i].x = Pts[i].x + (int)((ymax - Pts[i].y)/slope);
                  ClipPts[i].y = ymax;
                 
                  if ( InsideRect(Pts[i+1]) )
                  {
                    ClipPts[i+1].x = Pts[i+1].x;
                    ClipPts[i+1].y = Pts[i+1].y;
                  }
                  else
                  {
                    ClipPts[i+1].x = Pts[i+1].x - (int)((Pts[i+1].y-ymin)/slope);
                    ClipPts[i+1].y = ymin;
                  }
                }
              }
              else
              {
                /* P1 is in lower region ...below x=-y line */
                if ( slope > FindSlope(Pts[i].x,Pts[i].y,xmax,ymax) ||
                     slope < FindSlope(Pts[i].x,Pts[i].y,xmin,ymin) )
                {
                    ClipPts[i].x = -1;
                    ClipPts[i].y = 0; 
                  ClipPts[i+1].x = 0;
                  ClipPts[i+1].y = 0;
                }  
                else if ( slope > FindSlope(Pts[i].x,Pts[i].y,xmin,ymax) )
                {
                  ClipPts[i].x = Pts[i].x + (int)((ymax-Pts[i].y)/slope);
                  ClipPts[i].y = ymax;
                   
                  if ( InsideRect(Pts[i+1]) )
                  {
                    ClipPts[i+1].x = Pts[i+1].x;
                    ClipPts[i+1].y = Pts[i+1].y;
                  }
                  else
                  {
                    ClipPts[i+1].x = xmax;
                    ClipPts[i+1].y = Pts[i+1].y - (int)(slope*(Pts[i+1].x-xmax));
                  }
                }
                else if ( slope < FindSlope(Pts[i].x,Pts[i].y,xmax,ymin) )
                {
                  ClipPts[i].x = xmin;
                  ClipPts[i].y = Pts[i].y + (int)(slope*(xmin-Pts[i].x));
                   
                  if ( InsideRect(Pts[i+1]) )
                  {
                    ClipPts[i+1].x = Pts[i+1].x;
                    ClipPts[i+1].y = Pts[i+1].y;
                  }
                  else
                  {
                    ClipPts[i+1].x = Pts[i+1].x + (int)((ymin-Pts[i+1].y)/slope);
                    ClipPts[i+1].y = ymin;
                  }
                }
                else
                {
                  ClipPts[i].x = xmin;
                  ClipPts[i].y = Pts[i].y - (int)(slope*(Pts[i].x-xmin));
                 
                  if ( InsideRect(Pts[i+1]) )
                  {
                    ClipPts[i+1].x = Pts[i+1].x;
                    ClipPts[i+1].y = Pts[i+1].y;
                  }
                  else
                  {
                    ClipPts[i+1].x = xmax;
                    ClipPts[i+1].y = Pts[i+1].y - (int)(slope*(Pts[i+1].x-xmax));
                  }
                }
              }
            }
          }
          else    /* P1 is MIDDLE LEFT side */
          {
            if ( InsideRect(Pts[i+1]) )  /* If P2 is inside box */
            {
                ClipPts[i].x =  xmin;
                ClipPts[i].y =  Pts[i].y - (int)(slope*(Pts[i].x - xmin));
              ClipPts[i+1].x = Pts[i+1].x;
              ClipPts[i+1].y = Pts[i+1].y;
            }
            else if ( slope < FindSlope( Pts[i].x, Pts[i].y, xmin,ymin) )
            {
              /* P2 is to the left of LEFT-TOP corner */
                ClipPts[i].x = -1;
                ClipPts[i].y = 0;
              ClipPts[i+1].x = 0;
              ClipPts[i+1].y = 0;
            }
            else if ( (slope < FindSlope( Pts[i].x, Pts[i].y, xmax,ymin )) && 
                      (slope > FindSlope( Pts[i].x, Pts[i].y, xmin,ymin )) )
            {  
              /* P2  is Above & Outside box */
                ClipPts[i].x = xmin;
                ClipPts[i].y = Pts[i].y - (int)(slope*(Pts[i].x - xmin));
              ClipPts[i+1].x = Pts[i+1].x + (int)((ymin - Pts[i+1].y)/slope);
              ClipPts[i+1].y = ymin;
            } 
            else if ( (slope < FindSlope( Pts[i].x, Pts[i].y, xmin,ymax )) &&
                      (slope > FindSlope( Pts[i].x, Pts[i].y, xmax,ymax )) )
            {
              /* P2  is Below & Outside box */
                ClipPts[i].x = xmin;
                ClipPts[i].y = Pts[i].y - (int)(slope*(Pts[i].x - xmin));
              ClipPts[i+1].x = Pts[i+1].x + (int)((ymax - Pts[i+1].y)/slope);
              ClipPts[i+1].y = ymax; 
            }
            else if ( slope > FindSlope( Pts[i].x, Pts[i].y, xmin,ymax ) )
            {
               /* P2 is to the right of LEFT-BOTTOM corner */
                ClipPts[i].x = -1;   
                ClipPts[i].y = 0;
              ClipPts[i+1].x = 0;
              ClipPts[i+1].y = 0;
            }
            else  
            {
             /* P2 is to the right of the boundary box ...ie crosses box */
                ClipPts[i].x = xmin;
                ClipPts[i].y = Pts[i].y - (int)(slope*(Pts[i].x - xmin));
              ClipPts[i+1].x = xmax;
              ClipPts[i+1].y = Pts[i+1].y - (int)(slope*(Pts[i+1].x - xmax));
            } 
          }
        }
      }
    }
  }
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    reshape                                      +
   +                                                            +
   +  Purpose: This function allows the screen to be resized    +
   +            but the line draw still appears in its original +
   +            position and length.                            +
   +                                                            +
   +  Inputs: w and h - width and height of window              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void reshape (int w, int h)
{
  glViewport (0, 0, (GLsizei) w, (GLsizei) h);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  gluOrtho2D (0.0, (GLdouble) w,(GLdouble) h, 0.0);
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    SetCameraPosition                            +
   +                                                            +
   +  Purpose: This function sets the postion of the camera     +
   +                                                            +
   +  Inputs: none                                              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void SetCameraPosition(void)
{
  /* Set the viewing transformation */
  glMatrixMode(GL_PROJECTION); 
  glLoadIdentity();
  gluOrtho2D(0.0,(GLdouble)WinWidth+1.0,(GLdouble)WinHeight+1.0,0.0);
  glMatrixMode(GL_MODELVIEW);
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    init                                         +
   +                                                            +
   +  Purpose: This function clears the colors and initializes  +
   +            the shade model.                                +
   +                                                            +
   +  Inputs: none                                              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */   
void init(void)
{
  glClearColor(0.0, 0.0, 0.0, 0.0);
  glShadeModel(GL_FLAT);
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    display                                      +
   +                                                            +
   +  Purpose: To display the lines, clipping box and the       +
   +           clipped lines.                                   +
   +                                                            +
   +  Inputs: none                                              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void display(void)
{
  int i = 0;

  glClear(GL_COLOR_BUFFER_BIT);
  glColor3f(1.0,1.0,1.0);

  /* Draw the lines */
  if ( numPts%2 != 0 )
  {
    glPointSize(3.0);
    glBegin(GL_POINTS);
      glColor3f(0.0,1.0,0.0);
      glVertex2d(Pts[numPts-1].x,Pts[numPts-1].y);
    glEnd();
  }

  if ( numPts > 1 )
    for ( i=0 ; i<numPts-1 ; i+=2 )
    {
      glBegin(GL_LINE_STRIP);
        glColor3f(0.0,1.0,0.0);  
        glPointSize(1.0);
        glVertex2d(  Pts[i].x,   Pts[i].y);
        glVertex2d(Pts[i+1].x, Pts[i+1].y);
     glEnd();
    }


  /* Draw the Clipping Rectangle once both point are entered */
  if ( numRecPts == 1 )   
  {
    glBegin(GL_POINTS);
      glColor3f(0.0,0.0,1.0);
      glPointSize(3.0);
      glVertex2d(LeftPoint.x,LeftPoint.y);
    glEnd();
  }
  else
  {
   glBegin(GL_LINE_LOOP);
      glColor3f(0.0,0.0,1.0);
      glPointSize(1.0);
      glVertex2i(xmin, ymin);
      glVertex2i(xmin, ymax);
      glVertex2i(xmax, ymax);
      glVertex2i(xmax, ymin);
    glEnd();
  }

  /* Draw Clipped Lines if Clipping Rectangle is drawn */
  if ( numRecPts == 2 )
  {
    /* Call line clipping function. */
    Clipping();
   
    if ( numPts > 1 )
      for ( i=0 ; i<numPts-1 ; i+=2 )
        if ( ClipPts[i].x != -1 )
        {
          glBegin(GL_LINE_STRIP);
            glColor3f(1.0,0.0,0.0);  
            glPointSize(1.0);
            glVertex2d(  ClipPts[i].x,   ClipPts[i].y);
            glVertex2d(ClipPts[i+1].x, ClipPts[i+1].y);
          glEnd();
        }
  } 

  glFlush(); 
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    KeyPress                                     +
   +                                                            +
   +  Purpose: This function will check to see if the key       +
   +            pressed is a q (or Q). If so, then the program  +
   +            will terminate gracefully.                      +
   +                                                            +
   +  Inputs: Key (unsigned char) - Key pressed.                +
   +          X (int) - x location of mouse pointer.            +
   +          Y (int) - y location of mouse pointer.            +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void KeyPress(unsigned char Key, int X, int Y)
{
  if (toupper(Key) == 'Q')
    exit(0);
 
  if ( Key = '\b' )
    numPts = 0;

  glutPostRedisplay();
}
 
 
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    MouseButtonPressed                           +
   +                                                            +
   +  Purpose: To capture the input of endpoint for a line.     +
   +           On the depression of the left mouse button the   +
   +           current cursor position is used to capture the   +
   +           coordinates at the current point which are used  +
   +           to define the first or second endpoint.          +
   +                                                            +
   +  Inputs: Button - determines which button is selected.     +
   +          State - determines if button is pressed/released  +
   +          X,Y - coordinates of current cursor               +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void MouseButtonPressed(int Button, int State, int X, int Y)
{
  if (State == GLUT_DOWN)
  {
    if (Button == GLUT_LEFT_BUTTON)
    {
      /* If the number of points is less than 40 and the clipping box has
         not been started to be drawn then accept points. */
      if ( ( numPts < 40 ) && ( numRecPts != 1 ) )
      {
        /* If the number of points is odd then check if this points
           x value is less thaan the previous points...
           if so then swap points. */
        if ( numPts%2 == 1 )
        {
          /* Check if this points X value is less than previous points. */
          if ( X < Pts[numPts-1].x )
          {
            Pts[numPts].x = Pts[numPts-1].x;
	    Pts[numPts].y = Pts[numPts-1].y;

            Pts[numPts-1].x = X;
            Pts[numPts-1].y = Y;
          }
          else
          {
            Pts[numPts].x = X;    Pts[numPts].y = Y;
          }
        }
        else /* else just make the point the next point */
        {
          Pts[numPts].x = X;    Pts[numPts].y = Y;
        }
        
        numPts++;
      }
    }
    else if (Button == GLUT_RIGHT_BUTTON)
    { 
      /* If a box or no box exist and no starting points has been
         entered for a clipping box then accept points. */
      if ( numPts%2 == 0 )
      {
        if ( numRecPts != 1 )
        {
          LeftPoint.x = X;                LeftPoint.y = Y;
          numRecPts = 1;
        }
        else     /* else check if this 2nd points is left of the 1st */           
        {
          /* If new point is left of 1st box point then swap points */
          if ( X < LeftPoint.x )
          {
            RightPoint.x = LeftPoint.x;   
            RightPoint.y = LeftPoint.y;
            LeftPoint.x = X;              
            LeftPoint.y = Y;
          }
	  else
          {
            RightPoint.x = X;             RightPoint.y = Y;
          }

          numRecPts = 2;
          FindCorners();
        }
      }
    }               
  }

  glutPostRedisplay();
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    main                                         +
   +                                                            +
   +  Purpose: This is the main function of mp3. Most of the    +
   +            initialization of the display is done here and  +
   +            functions for events are invoked here.          +
   +                                                            +
   +  Inputs: none.                                             +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
int main(int argc, char **argv)
{
  /* Display quit procedure. */
  printf("CS318 - MP3 - Nicholl-Lee-Nicholl Clipping Algorithm\n");
  printf("INPUTS:\n");
  printf("Left Mouse Button   - Enter up to 40 Endpoints for 20 Lines\n");
  printf("Right Mouse Button  - Enter 2 Corners of Clipping Rectangle\n");
  printf("<Backspace>         - Clears all Endpoints and Lines\n");
  printf("'q' or 'Q'          - Quit Program\n");

  /* Initialize window. */
  glutInit(&argc, argv);
  glutInitWindowSize(WinWidth, WinWidth);
  glutInitWindowPosition(100, 100);
  glutCreateWindow("MP3: Nicholl-Lee-Nicholl Clipping Algorithm");
  init();

  /* Define camera position. */
  SetCameraPosition();

  /* Call display function and enter main loop. */
  glutDisplayFunc(display);
  glutMouseFunc(MouseButtonPressed);
  glutKeyboardFunc(KeyPress);
  glutReshapeFunc(reshape);
  glutMainLoop();

  return 0;
}

