/* *********************************************************************
   *                                                                   *
   *  NAME     : Mariusz Zaczek          PROGRAM : MP2                 *
   *  NET ID   : zaczek                  COURSE  : CS318 - Fall 1999   *
   *  DUE DATE : Oct. 8,1999                                           *
   *                                                                   *
   *  PURPOSE  : The purpose of this MP is to implement 2-D geometric  *
   *             transformations (translation, rotation and scaling).  *
   *                                                                   *
   *  INPUTS   : The input is obtained from the mouse which is used to *
   *             draw the polygon and position the rotation/scaling    *
   *             point. The user also uses the keyboard to select the  *
   *             transformation to use...once selected the user        *
   *             specifies:                                            *
   *                translation - x and y distances                    *
   *                rotation    - degrees for rotation                 *
   *                scaling     - x and y scaling factors.             *
   *                                                                   *
   ********************************************************************* */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <GL/glut.h>

/* Defines */
#define TRUE  1
#define FALSE 0

#ifndef PI
#define PI 3.14159265359
#endif

/* Structure for points. */
typedef struct
{
  int x,y;
} points;

/* Global variables for endpoints. */
int WinWidth = 600;
int WinHeight = 600;
int numPoints = 0;
int DoneDrawing = 1;
points myPoints[20];
points firstPoint;
points rotPoint = {300,300};

/* Global Matrix */
double    Matrix[16] = {1.0, 0.0, 0.0, 0.0,       
                        0.0, 1.0, 0.0, 0.0,
                        0.0, 0.0, 1.0, 0.0,
                        0.0, 0.0, 0.0, 1.0};

/* Current Matrix */
double CurMatrix[16] = {1.0, 0.0, 0.0, 0.0,
                        0.0, 1.0, 0.0, 0.0,
                        0.0, 0.0, 1.0, 0.0,
                        0.0, 0.0, 0.0, 1.0};
  

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    Identity                                     +
   +                                                            +
   +  Purpose: This function is make the inputted matrix into   + 
   +           an identity matrix.                              +
   +                                                            +
   +  Inputs: double theMatrix[] - matrix to be made into ident.+
   +                                                            +   
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Identity(double theMatrix[])
{
  int i=0;

  for ( i=0 ; i<16 ; i++)
    theMatrix[i] = 0.0;

  theMatrix[0] = theMatrix[5] = theMatrix[10] = theMatrix[15] = 1.0;
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    MatrixMultiply                               +
   +                                                            +
   +  Purpose: This function takes the inputted matrix          +
   +            _transMatrix_ and multiplies it with the        +
   +            global matrix: _Matrix_                         +
   +                                                            +
   +  Inputs: double transMatrix[] - a tranformation matrix     +
   +                                                            +   
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void MatrixMultiply(double transMatrix[])
{
  double newMatrix[16];
  int i=0;

  for ( i=0 ; i<4 ; i++ )
    newMatrix[i] = transMatrix[ i%4   ] * Matrix[ 0 ]
                 + transMatrix[ i%4+4 ] * Matrix[ 1 ]
                 + transMatrix[ i%4+8 ] * Matrix[ 2 ]
                 + transMatrix[ i%4+12] * Matrix[ 3 ];
  
  for ( i=4 ; i<8 ; i++ )
    newMatrix[i] = transMatrix[ i%4   ] * Matrix[ 4 ]
                 + transMatrix[ i%4+4 ] * Matrix[ 5 ]
                 + transMatrix[ i%4+8 ] * Matrix[ 6 ]
                 + transMatrix[ i%4+12] * Matrix[ 7 ];
  for ( i=8 ; i<12 ; i++ )
    newMatrix[i] = transMatrix[ i%4   ] * Matrix[ 8 ]
                 + transMatrix[ i%4+4 ] * Matrix[ 9 ]
                 + transMatrix[ i%4+8 ] * Matrix[ 10 ]
                 + transMatrix[ i%4+12] * Matrix[ 11 ];
  for ( i=12 ; i<16 ; i++ )
    newMatrix[i] = transMatrix[ i%4   ] * Matrix[ 12 ]
                 + transMatrix[ i%4+4 ] * Matrix[ 13 ]
                 + transMatrix[ i%4+8 ] * Matrix[ 14 ]
                 + transMatrix[ i%4+12] * Matrix[ 15 ];
  
  for ( i=0 ; i<16 ; i++ )
    Matrix[i] = newMatrix[i];

}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    Reset                                        +
   +                                                            +
   +  Purpose: This function resets the position of the polygon +
   +           to the original position.                        +
   +                                                            +
   +  Inputs: none                                              +
   +                                                            +   
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Reset(void)
{
  Identity(Matrix);
}

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    Rotate                                       +
   +                                                            +
   +  Purpose: This function is used to rotate a polygon about  +
   +           the current rotation point.                      +
   +                                                            +
   +  Inputs: none - User is prompted to enter rotation angle.  +
   +                                                            +   
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Rotate(void)
{
  double degrees, radians, cosVal, sinVal;
  int i=0;
 
  printf("Enter the degrees to rotate counterclockwise: ");
  scanf("%lf",&degrees);

  radians =  ( -degrees * PI ) / 180.0;

  /* Clear current matrix */
  Identity(CurMatrix);

  cosVal = cos(radians);
  sinVal = sin(radians);

  /* NOTE: Remember to flip the "y" values. */
  CurMatrix[0] = cosVal;
  CurMatrix[1] = sinVal;
  CurMatrix[4] = -sinVal;
  CurMatrix[5] = cosVal;
  CurMatrix[12] = rotPoint.x * (1.0-cosVal) + rotPoint.y * sinVal;
  CurMatrix[13] = rotPoint.y * (1.0-cosVal) - rotPoint.x * sinVal;

  /* Update the global matrix with the current transformation. */
  MatrixMultiply(CurMatrix);
}
  

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            + 
   +  Function:    Scale                                        + 
   +                                                            +
   +  Purpose: This function is used to scale a polygon.        +
   +                                                            +
   +  Inputs: none - User is prompted to enter x and y          + 
   +                 axis scaling factors.                      +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Scale(void)
{
  double x_scale = 1.0, y_scale = 1.0;
  int i=0;

  printf("Enter the amounts to scale as x,y: ");
  scanf("%lf%lf",&x_scale,&y_scale);

  /* Make sure that scaling factor is not zero. */
  if ( x_scale == 0.0 )
    x_scale = 1.0;
  
  if ( y_scale == 0.0 )
    y_scale = 1.0;

  /* Clear the current matrix. */
  Identity(CurMatrix);

  CurMatrix[0] = x_scale;
  CurMatrix[12] = rotPoint.x * ( 1 - x_scale );
  CurMatrix[5] = y_scale;
  CurMatrix[13] = rotPoint.y * ( 1 - y_scale );

  /* Update the global matrix with the current transformation. */
  MatrixMultiply(CurMatrix);
}
  

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    Translate                                    +
   +                                                            +
   +  Purpose: This function is used to translate a polygon.    +
   +                                                            +
   +  Inputs: none - User is prompted to enter x and y          +                     
   +                 axis translation distances.                +
   +                                                            +   
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Translate(void)
{
  double x = 0, y = 0;
  int i=0;
                        
  printf("Enter the amounts to translate as x,y: ");
  scanf("%lf%lf",&x,&y);
 
  /* Clear the current matrix. */
  Identity(CurMatrix);  
                      
  CurMatrix[12] = x;
  CurMatrix[13] = -y;

  /* Update the global matrix with the current transformation. */
  MatrixMultiply(CurMatrix);
} 



/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    reshape                                      +
   +                                                            +
   +  Purpose: This function allows the screen to be resized    +
   +            but the line draw still appears in its original +
   +            position and length.                            +
   +                                                            +
   +  Inputs: w and h - width and height of window              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void reshape (int w, int h)
{
  glViewport (0, 0, (GLsizei) w, (GLsizei) h);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  gluOrtho2D (0.0, (GLdouble) w,(GLdouble) h, 0.0);
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    SetCameraPosition                            +
   +                                                            +
   +  Purpose: This function sets the postion of the camera     +
   +                                                            +
   +  Inputs: none                                              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void SetCameraPosition(void)
{
  /* Set the viewing transformation */
  glMatrixMode(GL_PROJECTION); 
  glLoadIdentity();
  gluOrtho2D(0.0,(GLdouble)WinWidth+1.0,(GLdouble)WinHeight+1.0,0.0);
  glMatrixMode(GL_MODELVIEW);
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    init                                         +
   +                                                            +
   +  Purpose: This function clears the colors and initializes  +
   +            the shade model.                                +
   +                                                            +
   +  Inputs: none                                              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */   
void init(void)
{
  glClearColor(0.0, 0.0, 0.0, 0.0);
  glShadeModel(GL_FLAT);
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    display                                      +
   +                                                            +
   +  Purpose: This function display the spirograph. It uses    +
   +            the two global variables (num_vertices and      +
   +            step_size) to determine the number of vertices  +
   +            of the spirograph and the pattern the lines     +
   +            connecting the vertices should use.             +
   +                                                            +
   +  Inputs: none                                              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void display(void)
{
  int i = 0;

  glClear(GL_COLOR_BUFFER_BIT);
  glColor3f(1.0,1.0,1.0);


  if ( ( numPoints == 20 ) || 
       ( numPoints >= 3 ) &&
       ( abs( myPoints[numPoints-1].x - firstPoint.x ) <= 3 &&
         abs( myPoints[numPoints-1].y - firstPoint.y ) <= 3 ) )
    DoneDrawing = TRUE;

  /* If the user is still drawing points then continue to 
     draw a unfilled polygon. */
  if ( DoneDrawing == FALSE )
  {
    /* Draw the first point with a size 3 ... 
             all others are size 1 */
    glPointSize(3.0);
    glBegin(GL_POINTS);
      glColor3f(1.0,1.0,0.0);
      glVertex2d(myPoints[0].x,myPoints[0].y);
    glEnd();

    glBegin(GL_LINE_STRIP);
      glPointSize(1.0);
      for ( i=0 ; i<numPoints ; i++ )
        glVertex2d(myPoints[i].x,myPoints[i].y);
    glEnd();  
  }
  else
  {
    /* Load the new global matrix so that any tranformation can
       be drawn. */
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    glLoadMatrixd(Matrix);

    /* Draw filled in polygon. */
    glPointSize(1.0);
    glBegin(GL_POLYGON);
      glColor3f(1.0,1.0,0.0);
    
      for ( i=0 ; i<numPoints ; i++ )
        glVertex2d(myPoints[i].x,myPoints[i].y);
  
      glVertex2d(myPoints[0].x,myPoints[0].y);
    glEnd();
  }

  /* Draw the rotation point in color:magenta */
  glLoadIdentity();
  glPointSize(3.0);
  glBegin(GL_POINTS);
     glColor3f(1.0,0.0,1.0);
     glVertex2d(rotPoint.x,rotPoint.y);
   glEnd();

  glFlush(); 
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    KeyPress                                     +
   +                                                            +
   +  Purpose: This function will check to see if the key       +
   +            pressed is a q (or Q). If so, then the program  +
   +            will terminate gracefully.                      +
   +                                                            +
   +  Inputs: Key (unsigned char) - Key pressed.                +
   +          X (int) - x location of mouse pointer.            +
   +          Y (int) - y location of mouse pointer.            +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void KeyPress(unsigned char Key, int X, int Y)
{
  if (toupper(Key) == 'Q')
    exit(0);

  if ( DoneDrawing == TRUE )
    switch(toupper(Key))
    {
      case 'I': 
            Reset();
            break;
      case 'T':
            Translate();
            break;
      case 'R':
            Rotate();
            break;
      case 'S':
            Scale();
            break;
      default:
             break;
    }
    
  glutPostRedisplay();
}
 
 
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    MouseButtonPressed                           +
   +                                                            +
   +  Purpose: To capture the input of endpoint for a line.     +
   +           On the depression of the left mouse button the   +
   +           current cursor position is used to capture the   +
   +           coordinates at the current point which are used  +
   +           to define the first or second endpoint.          +
   +                                                            +
   +  Inputs: Button - determines which button is selected.     +
   +          State - determines if button is pressed/released  +
   +          X,Y - coordinates of current cursor               +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void MouseButtonPressed(int Button, int State, int X, int Y)
{
  if (State == GLUT_DOWN)
  {
    if (Button == GLUT_LEFT_BUTTON)
    {
      if ( DoneDrawing == TRUE )
      {
        Identity(Matrix);

        firstPoint.x = X;       firstPoint.y = Y;
        myPoints[0].x = X;      myPoints[0].y =Y;
        DoneDrawing = FALSE;         
        numPoints = 1;
      }
      else
      {
        myPoints[numPoints].x = X;         myPoints[numPoints].y = Y;
        numPoints++;
      }
    }
    else if (Button == GLUT_RIGHT_BUTTON)
    {
      rotPoint.x = X;           rotPoint.y = Y;        
    }               
  }
    
  glutPostRedisplay();
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    main                                         +
   +                                                            +
   +  Purpose: This is the main function of mp1. Most of the    +
   +            initialization of the display is done here and  +
   +            functions for events are invoked here.          +
   +                                                            +
   +  Inputs: none.                                             +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
int main(int argc, char **argv)
{
  /* Display quit procedure. */
  printf("CS318 - MP2 - Two-Dimensional Transformations\n");
  printf("INPUTS:\n");
  printf("Left Mouse Button   - Enter up to 20 Vertices for Polygon\n");
  printf("Right Mouse Button  - Set the Rotation Point\n");
  printf("'i' or 'I'          - Reset all Transformations\n");
  printf("'r' or 'R'          - Prompt for Degrees to Rotate (ccw)\n");
  printf("'t' or 'T'          - Prompt for Pixels to Translate tx ty\n");
  printf("'s' or 'S'          - Prompt for Scaling Factors sx sy\n");
  printf(" ** Note ** Do not use commas between values \n");
  printf("'q' or 'Q'          - Quit Program\n");


  /* Initialize window. */
  glutInit(&argc, argv);
  glutInitWindowSize(WinWidth, WinWidth);
  glutInitWindowPosition(100, 100);
  glutCreateWindow("MP2: Two-Dimensional Geometric Transformations");
  init();

  /* Define camera position. */
  SetCameraPosition();

  /* Call display function and enter main loop. */
  glutDisplayFunc(display);
  glutMouseFunc(MouseButtonPressed);
  glutKeyboardFunc(KeyPress);
  glutReshapeFunc(reshape);
  glutMainLoop();

  return 0;
}

