/* *********************************************************************
   *                                                                   *
   *  NAME     : Mariusz Zaczek          PROGRAM : MP1                 *
   *  NET ID   : zaczek                  COURSE  : CS318 - Fall 1999   *
   *  DUE DATE : Sept. 24,1999                                         *
   *                                                                   *
   *  PURPOSE  : The purpose of this MP is to implement the Midpoint   *
   *             Line Algorithm to draw lines pixel-by-pixel.          *
   *                                                                   *
   *  INPUTS   : 2 mouse inputs defining the 1st and 2nd endpoint of   *
   *             line to be drawn.                                     *
   *                                                                   *
   ********************************************************************* */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include <GL/glut.h>

/* Global variables for endpoints. */
int WinWidth=500;
int WinHeight=500;

int X1 = 0;              /* x location of 1st endpoint */
int Y1 = 0;              /* y    "       "       "     */
int X2 = 0;              /* x    "        2nd    "     */
int Y2 = 0;              /* y    "       "       "     */

int currentpt = 0;   /* Flag to determine which point to plot...
                       0 = 1st point,  1 = 2nd point     */


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    reshape                                      +
   +                                                            +
   +  Purpose: This function allows the screen to be resized    +
   +            but the line draw still appears in its original +
   +            position and length.                            +
   +                                                            +
   +  Inputs: w and h - width and height of window              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void reshape (int w, int h)
{
  glViewport (0, 0, (GLsizei) w, (GLsizei) h);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  gluOrtho2D (0.0, (GLdouble) w,(GLdouble) h, 0.0);
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    SetCameraPosition                            +
   +                                                            +
   +  Purpose: This function sets the postion of the camera     +
   +                                                            +
   +  Inputs: none                                              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void SetCameraPosition(void)
{
  /* Set the viewing transformation */
  glMatrixMode(GL_PROJECTION); 
  glLoadIdentity();
  gluOrtho2D(0.0,(GLdouble)WinWidth+1.0,(GLdouble)WinHeight+1.0,0.0);
  glMatrixMode(GL_MODELVIEW);
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    init                                         +
   +                                                            +
   +  Purpose: This function clears the colors and initializes  +
   +            the shade model.                                +
   +                                                            +
   +  Inputs: none                                              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */   
void init(void)
{
  glClearColor(0.0, 0.0, 0.0, 0.0);
  glShadeModel(GL_FLAT);
}

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    DrawLine                                     +
   +                                                            +
   +  Purpose: This function is used to determine the how to    +
   +           the line defined by two end-points. The midpoint +
   +           line algorithm is used to determine successive   +
   +           points of a line.                                +
   +                                                            +
   +  Inputs: X1, Y1     - coordinates of endpoint #1           +
   +          X2, Y2     - coordinates of endpoint #2           +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void DrawLine(int X1, int Y1, int X2, int Y2)
{
  int deltax = X2 - X1,    /* Change in x-coordinates */
      deltay = Y2 - Y1,    /* Change in y-coordinates */
      majorIncrA = 0,
      majorIncrB = 0,
      minorIncrA = 0,
      minorIncrB = 0,
      twop_o = 0,          /* Initial decision paramter */
      twopleft = 0,        /* ... (p<0) addition to decision param. */
      twopright = 0;       /* ... (p>=0) addition to decision param. */

  int current_x = X1,      /* Initialize 1st endpoint to current endpt.*/
      current_y = Y1;

  /* Determine if absolute value of slope is less than 1 ... if so
     then deal with only four cases of lines...all of which have a 
     slope whose absolute value is less than 1 -  abs(slope) < 1 */
  if ( abs(deltay) <= abs(deltax) )
  {
    /* Determine if first point is to the left of second point
       ...if so then there are only two possible cases of this.
       the lines are in the 1st and 8th octants. */
    if ( X1 < X2 )
    {
      /* X will always be incremented for these two cases. */
      majorIncrA = 1;

      /* If first endpoint is below second endpoint...1st octant */
      if ( Y1 < Y2 )      /* CASE 1 */
      {
        twop_o = 2*deltay - deltax; 
        twopleft = 2*deltay;         twopright = 2*( deltay - deltax );
        minorIncrA = 0;
        minorIncrB = 1;
      }
      else                /* CASE 8 */
      {
        twop_o = 2*deltay + deltax;
        twopright = 2*deltay;         twopleft = 2*( deltay + deltax );
        minorIncrA = -1;
        minorIncrB = 0;
      }
    }
    else       /* ...else if first point is to the right of second pt. */
    {
      /* For these two cases, X will always be decrimented */
      majorIncrA = -1; 
  
      if ( Y1 < Y2 )        /* CASE 4 */
      {
        twop_o = -2*deltay - deltax;
        twopright = -2*deltay;        twopleft = 2*(-deltay - deltax);
        minorIncrA = 1;
        minorIncrB = 0;
      } 
      else                  /* CASE 5 */
      {
        twop_o = -2*deltay + deltax;        
        twopleft = -2*deltay;         twopright = 2*(-deltay+deltax);
        minorIncrA = 0;
        minorIncrB = -1;
      }
    }
      
    /* WHILE LOOP #1  - Draw the line of the 1,4,5 & 8th octants 
       ... draw until current x coordinate is equal to 2nd pt's X value */
    while ( current_x != X2 )
    {
      /* Increment or Decrement X depending on what the value of 
         majorIncrA was found previously */
      current_x += majorIncrA;
     
      /* If the decision parameter is less than 0 */
      if ( twop_o < 0 )
      {     
        twop_o += twopleft;
        current_y += minorIncrA;
      }
      else   /* If decision parameter is greater or equal to zero */
      { 
        twop_o += twopright;
        current_y += minorIncrB;
      }

      /* Draw point */
      glBegin(GL_POINTS);
        glVertex2d(current_x,current_y);
      glEnd();      
    }  
  }
  else   /* If abs(slope) is between 1 and infinity */
  {
    /* If point 1 is below point 2 ... i.e. only lines in the
       2nd and 3rd octants */
    if ( Y1 < Y2 )
    {
      /* Set increment/decrement parameter to +1 */
      majorIncrB = 1;

      /* If point 1 is to the left of point 2 ... i.e. 2nd octant */
      if ( X1 < X2 )      /* CASE 2 */
      {
        twop_o = deltay - 2*deltax;
        twopright = -2*deltax;        twopleft = 2*(deltay - deltax);
        minorIncrA = 0;
        minorIncrB = 1;
      }
      else                /* CASE 3 */
      {
        twop_o = -deltay - 2*deltax;
        twopleft = -2*deltax;          twopright = 2*(-deltay - deltax);
        minorIncrA = -1;
        minorIncrB = 0;
      }
    }
    else    /* ...else we are dealing with lines in 6th & 7th octants */
    {
      /* Set increment/decrement operator to decrement by 1 */
      majorIncrB = -1;
 
      /* If 1st point is to the left of 2nd point...octant 7 */
      if ( X1 < X2 )    /* CASE 7 */
      {
        twop_o = deltay + 2*deltax;
        twopleft = 2*deltax;         twopright = 2*(deltay + deltax);
        minorIncrA = 1;
        minorIncrB = 0;
      }
      else          /* CASE 6 */ 
      {
         twop_o = -deltay + 2*deltax;
        twopright = 2*deltax;           twopleft = 2*(-deltay + deltax);
        minorIncrA = 0;
        minorIncrB = -1;
       }
    }
     
    /* WHILE LOOP #2  - Draw the line of the 2,3,6 & 7th octants
       ... draw until current y coordinate is equal to 2nd pt's Y value */
    while ( current_y != Y2 )
    {
      /* Increment or Decrement current Y value */
      current_y += majorIncrB;
       
      /* If decision parameter is less than zero */
      if ( twop_o < 0 )
      {
        twop_o += twopleft;
        current_x += minorIncrB;
      }
      else
      {
        twop_o += twopright;
        current_x += minorIncrA;
      }
  
      /* Draw point */
      glBegin(GL_POINTS);
        glVertex2d(current_x,current_y);
      glEnd();
    }
  }
  
}

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    display                                      +
   +                                                            +
   +  Purpose: This function display the spirograph. It uses    +
   +            the two global variables (num_vertices and      +
   +            step_size) to determine the number of vertices  +
   +            of the spirograph and the pattern the lines     +
   +            connecting the vertices should use.             +
   +                                                            +
   +  Inputs: none                                              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void display(void)
{
  glClear(GL_COLOR_BUFFER_BIT);
  glColor3f(1.0,1.0,1.0);

  /* Draw 1st point */
  glPointSize(3.0);
  glBegin(GL_POINTS);
    glColor3f(0.0, 1.0, 0.0);
    glVertex2d(X1,Y1);
  glEnd();

  if (currentpt == 0)
  {
    glPointSize(3.0);
    /* Draw 2nd point */
    glBegin(GL_POINTS);
      glColor3f(1.0, 0.0, 0.0);
      glVertex2d(X2,Y2);
    glEnd();
  }

  /* Draw line by calling midpoint algorithm function */
  glPointSize(1.0);
  if ( currentpt == 0 )
  {
    glColor3f(1.0, 1.0, 1.0);
    DrawLine(X1,Y1,X2,Y2);
  }
   
    glFlush(); 
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    KeyPress                                     +
   +                                                            +
   +  Purpose: This function will check to see if the key       +
   +            pressed is a q (or Q). If so, then the program  +
   +            will terminate gracefully.                      +
   +                                                            +
   +  Inputs: Key (unsigned char) - Key pressed.                +
   +          X (int) - x location of mouse pointer.            +
   +          Y (int) - y location of mouse pointer.            +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void KeyPress(unsigned char Key, int X, int Y)
{
  if (toupper(Key) == 'Q')
    exit(0);
}
 
 
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    MouseButtonPressed                           +
   +                                                            +
   +  Purpose: To capture the input of endpoint for a line.     +
   +           On the depression of the left mouse button the   +
   +           current cursor position is used to capture the   +
   +           coordinates at the current point which are used  +
   +           to define the first or second endpoint.          +
   +                                                            +
   +  Inputs: Button - determines which button is selected.     +
   +          State - determines if button is pressed/released  +
   +          X,Y - coordinates of current cursor               +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void MouseButtonPressed(int Button, int State, int X, int Y)
{
  if (State == GLUT_DOWN)
  {
    if (Button == GLUT_LEFT_BUTTON)
    {
      /* A new endpoint needs to be plotted. */
      /* Make sure you keep track of both endpoints. */
      if ( currentpt == 0 )
      {
        currentpt = 1;
        X1 = X;
        Y1 = Y;
      }
      else
      {
        currentpt = 0;
        X2 = X;
        Y2 = Y;
      }
    }
               
    glutPostRedisplay();
  }
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    main                                         +
   +                                                            +
   +  Purpose: This is the main function of mp1. Most of the    +
   +            initialization of the display is done here and  +
   +            functions for events are invoked here.          +
   +                                                            +
   +  Inputs: none.                                             +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
int main(int argc, char **argv)
{
  /* Display quit procedure. */
  printf("\nPress q or Q to quit\n");

  /* Initialize window. */
  glutInit(&argc, argv);
  glutInitWindowSize(500, 500);
  glutInitWindowPosition(100, 100);
  glutCreateWindow("MP1: Midpoint Line Algorithm");
  init();

  /* Define camera position. */
  SetCameraPosition();

  /* Call display function and enter main loop. */
  glutDisplayFunc(display);
  glutMouseFunc(MouseButtonPressed);
  glutKeyboardFunc(KeyPress);
  glutReshapeFunc(reshape);
  glutMainLoop();
  return 0;

}



/* ********************************************************************
   *                                                                  *
   *   Derivation of Midpoint Line Algorithm                          *
   *                                                                  *
   ******************************************************************** */

/*  --------------------------------------------------------
 *  - CASE 1: Line in the first octant with 0 < slope < 1  -
 *  --------------------------------------------------------
 *  Step 1: - Put the equation of  line into parameteric form.
 *     y = mx + b  --> f(x,y) = x*deltaY - y*deltaX + deltaX*b
 *
 *  Step 2: Plug in the midpoint.
 *     f(x+1,y+1/2) = (x+1)*deltaY - (y+1/2)*deltaX + deltaX*b
 *                  = x*deltaY + deltaY - y*deltaX - (1/2)*deltaX + deltaX*b
 *                  = f(x,y) + deltaY -(1/2)*deltaX
 *
 *  Step 3: Plug in first point to get initial decision parameter.
 *     p_o = deltaY - (1/2)*deltaX
 *
 *  Step 4: Find the left and right decision parameters which are selected
 *          depending on the value of p_o.
 * 
 *     if ( p_o < 0 ) then choose (x+1,y) and calculate the update for the
 *       decision parameter
 *         f(x+2,y+1/2) = (x+2)*deltaY - (y+1/2)*deltaX + deltaX*b
 *                      = x*deltaY + 2*deltaY - y*deltaX - (1/2)*deltaX + deltaX*b
 *                      = f(x,y) + deltaY - (1/2)*deltaX + deltaY  
 *                      = p_o + deltaY
 *
 *     if ( p_o >= 0 ) then choose (x+1,y+1) and calculate the update for the
 *       decision parameter
 *         f(x+2,y+3/2) = (x+2)*deltaY - (y+3/2)*deltaX + deltaX*b
 *                      = x*deltaY + 2*deltaY - y*deltaX - (3/2)*deltaX + deltaX*b
 *                      = f(x,y) + deltaY - (1/2)*deltaX + deltaY -(2/2)*deltaX         
 *                      = p_o + deltaY - deltaX
 *
 *   
 * 
 *   SIMILARLY FOR OTHER CASES:
 *
 *    (2nd - octant)   
 *              p_o = (1/2)*deltaY - deltaX 
 *       (p<0) pk+1 = p_o + deltaY - deltaX
 *      (p>=0) pk+1 = p_o - deltaX
 *      
 *    (3rd - octant) 
 *              p_o = -(1/2)*deltaY - deltaX
 *       (p<0) pk+1 = p_o - deltaX
 *      (p>=0) pk+1 = p_o - deltaX - deltaY
 *
 *    (4th - octant)
 *              p_o = -deltaY - (1/2)*deltaX
 *       (p<0) pk+1 = p_o - deltaY - deltaX
 *      (p>=0) pk+1 = p_o - deltaY
 *
 *    (5th - octant)
 *              p_o = -deltaY + (1/2)*deltaX
 *       (p<0) pk+1 = p_o - deltaY
 *      (p>=0) pk+1 = p_o + deltaX - deltaY
 *
 *    (6th - octant) 
 *              p_o = deltaX - (1/2)*deltaY
 *       (p<0) pk+1 = p_o - deltaY + deltaX
 *      (p>=0) pk+1 = p_o + deltaX 
 *
 *    (7th - octant)
 *              p_o = deltaX + (1/2)*deltaY 
 *       (p<0) pk+1 = p_o + deltaX
 *      (p>=0) pk+1 = p_o + deltaY + deltaX
 *
 *    (8th - octant)
 *              p_o = deltaY + (1/2)*deltaX
 *       (p<0) pk+1 = p_o + deltaX + deltaY
 *      (p>=0) pk+1 = p_o + deltaY
 *
 *
 *
 *  Step 5 - Actual code implementation
 *     - The selection of which initial and update parameter to use is
 *       based on the coordinates of the two end-points. The slope is
 *       is used as a method of dividing the 8 cases into 2 sets of 4 
 *       cases each. The first set contains all lines which have a slope
 *       whose absolute value is between 0 and 1, while the second set lines
 *       have a slope between 1 and infinity (oo). The first set 
 *       corresponds to octants 1,4,5,8 while the second has octants 2,3,6,7.
 *
 *       So, taking the set of lines with abs(slope) between 0 and 1 we 
 *       must further segregate the lines so as to choose the appropriate
 *       decision parameters. Checking if the first endpoint's X value is
 *       less than the second endpoints's X value will separate the 4 lines
 *       into the right half lines (octants 1 & 8) and the left hand lines
 *       (octants 4 & 5). Knowing that we are in the right half side of a
 *       normal coordinate system, we know also that X will be incremented by
 *       +1. If the left hand system was selected then X would be decremented
 *       by 1 (or incremented by -1). So now we are left with two possibilities:
 *       the 1st and 8th octant lines. We determine which line to draw by 
 *       comparing the Y coordinate values. If Y of the first point is less than
 *       Y of the second then we are in the first octant, else we are in the
 *       eight octant.
 *
 *       Now we are able to calculate the decision parameters for the particular
 *       case. Let's assume we are using CASE 1, corresponding to the first 
 *       octant. Once we calculate the initial decision parameter we also
 *       calculate the possible LEFT and RIGHT decision parameters. Also, two
 *       minorIncr? (A & B) increment values are defined for each case. These
 *       are used in the WHILE loop to determine how to increment/decrement
 *       the Y coordinate. In CASE 1 if ( p_o < 0 ) then only X should be incremented
 *       by 1 while Y should remain the same. In the WHILE loop, when p_o<0
 *       is selected then Y gets incremented by _minorIncrA_ which for case 1
 *       equals 0 (zero) - as a result Y remains the same. If for example CASE 8 
 *       was used and (p_o<0) then this corresponds to the current Y position to
 *       decrease by 1 - hence the -1 increment value associated with CASE 8 and
 *       defined in _minorIncrA_. A similar variable is kept for when (p_o >= 0)
 *       and is kept by the variable _minorIncrB_. Note that this value will
 *       not affect the Y position when p_o is less than 0 (zero).
 *
 *       As mentioned, the WHILE loop for cases of  0 < abs(slope) < 1, X is
 *       always incremented or decremented (by the value of majorIncrA). The
 *       Y coordinate is only incremented if the _minorIncrA_ value is non-zero
 *       for each case of (p_o < 0) or (p_o >= 0). After each decision parameter
 *       is updated and the coordinates are updated, the point if finally draw.
 *
 *       A similar procedure for the cases of slope:   1 <= abs(slope) <= oo 
 *       is done in the "ELSE" portion of the code. A second WHILE loop is
 *       contained therein.
 *
 *       If this seems confusing to you, then you should know that I was  
 *       confused as well when I was coding the mp ... but it works.   :)  
 *
 */
