/* *********************************************************************
   *                                                                   *
   *  NAME     : Mariusz Zaczek          PROGRAM : MP0                 *
   *  NET ID   : zaczek                  COURSE  : CS318 - Fall 1999   *
   *  DUE DATE : Sept. 10, 1999                                        *
   *                                                                   *
   *  PURPOSE  : The purpose of this program is to generate a          *
   *             spirograph as well as learn the basics of OpenGL in   *
   *             the process.					       *
   *                                                                   *
   *  INPUTS   : num_vertices - specifies the number of vertices of    *
   *                            the spirograph (odd int between 3-99)  *
   *             step_size    - specifies the step size that each line *
   *                            should make when connecting vertices.  *
   *             q or Q       - Allows the user to quit the application*
   *                            by hitting q or Q                      *
   *                                                                   *
   ********************************************************************* */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include <GL/glut.h>

/* Define PI if it is not originally defined. */
#ifndef PI
#define PI 3.14159265359
#endif

/* Define input variables as global. */
int num_vertices;   
int step_size;

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    SetCameraPosition                            +
   +                                                            +
   +  Purpose: This function sets the postion of the camera     +
   +                                                            +
   +  Inputs: none                                              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void SetCameraPosition(void)
{
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluOrtho2D(-1.05, 1.05, -1.05, 1.05);
  glMatrixMode(GL_MODELVIEW);
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    init                                         +
   +                                                            +
   +  Purpose: This function clears the colors and initializes  +
   +            the shade model.				+
   +                                                            +
   +  Inputs: none                                              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */   
void init(void)
{
  glClearColor(0.0, 0.0, 0.0, 0.0);
  glShadeModel(GL_FLAT);
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    display                                      +
   +                                                            +
   +  Purpose: This function display the spirograph. It uses    +
   +            the two global variables (num_vertices and      +
   +            step_size) to determine the number of vertices  +
   +            of the spirograph and the pattern the lines     +
   +            connecting the vertices should use.             +
   +                                                            +
   +  Inputs: none                                              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void display(void)
{
  float   rad_angle;
  int 	  i, currentpt=0;

  glClear(GL_COLOR_BUFFER_BIT);
  glColor3f(1.0,1.0,1.0);

  /* Calculate the angle (in radians) between 
     each successive vertex. */
  rad_angle = 2*PI/num_vertices;

  /* Begin the loop for drawing lines...this loop requires
     all vertices in order that they should be connected. The
     last vertex connected will be the first vertex intialized
     thus making a closed loop. */
  glBegin(GL_LINE_LOOP);
    glVertex2f(1.0,0.0);     /* First (and last) vertex */
    
    /* Loop through remainder of vertices 
       and define their coordinates. */
    for( i=2 ; i<=num_vertices ; i++ )
    {
      glVertex2f(cos((currentpt+step_size)*rad_angle),
	         sin((currentpt+step_size)*rad_angle));
      
      currentpt = (currentpt+step_size) % num_vertices;
    }
  glEnd();    /* End of GL_LINE_LOOP  */

  glFlush();
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    KeyPress                                     +
   +                                                            +
   +  Purpose: This function will check to see if the key       +
   +            pressed is a q (or Q). If so, then the program  +
   +            will terminate gracefully.                      +
   +                                                            +
   +  Inputs: Key (unsigned char) - Key pressed.		+
   +          X (int) - x location of mouse pointer.            +
   +          Y (int) - y location of mouse pointer.            +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void KeyPress(unsigned char Key, int X, int Y)
{
  if (toupper(Key) == 'Q')
    exit(0);
}
 
 
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Function:    main                                         +
   +                                                            +
   +  Purpose: This is the main function of mp0. Most of the    +
   +            initialization of the display is done here and  +
   +            functions for events are invoked here.          +
   +                                                            +
   +  Inputs: argc (int) - the number of arguments at the       +
   +                       command line.                        +
   +          argv (char) - a array of all command line         +
   +                        arguments. This includes:           +
   +                        argv[0] = mp0                       +
   +                        argv[1] = <num_vertices>            +
   +                        argv[2] = <step_size>               +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
int main(int argc, char **argv)
{

  /* Check usage of input...i.e. if arguments for vertices and
      step size are correctly entered...if not then print usage
      and quit. */
  if (argc == 3)   /* Are there 3 arguments entered? */
  {
    /* Convert command line arguments to integers and assign to
       variables. */
    num_vertices = atoi(argv[1]);
    step_size = atoi(argv[2]);
    

    /* Check if all variables are within required bounds. 
	   where num_vertices should be an odd integer between
	   3 and 99, while step_size is between 1 and the 
	   num_vertices minus one. */
    if ( ( num_vertices<3 ) || ( num_vertices>99 ) || 
         ( step_size<1 ) || ( step_size >= num_vertices ) ||
		 ( num_vertices % 2 == 0) )
    {
      printf("\nUsage: mp0 [num_vertices] [step_size]"
             "\n   num_vertices:  3 -- 99 (odd)"
             "\n   step_size: 1 -- (num_vertices-1)\n");
      exit(0);
    }
  }
  else
  {
    printf("\nUsage: mp0 [num_vertices] [step_size]"
           "\n   num_vertices:  3 -- 99 (odd)"  
           "\n   step_size: 1 -- (num_vertices-1)\n");
    exit(0);
  }

  /* Display quit procedure. */
  printf("\nPress q or Q to quit\n");

  /* Initialize window. */
  glutInit(&argc, argv);
  glutInitWindowSize(500, 500);
  glutInitWindowPosition(100, 100);
  glutCreateWindow("MP0: Spirograph");
  init();

  /* Define camera position. */
  SetCameraPosition();

  /* Call Spirograph display function and enter main loop. */
  glutDisplayFunc(display);
  glutKeyboardFunc(KeyPress);
  glutMainLoop();
  return 0;
}

