#ifndef _SymbolTable_h_
#define _SymbolTable_h_

#include "StringHash.h"
#include "stack.h"

class SymbolTable{
public:

  // Default constructor
  SymbolTable();

  // Destructor
  ~SymbolTable();

  // Declaration of a new variable
  void  Declare(String VarName);

  // A procedure call
  void CallProcedure();

  // Procedure return
  void ExitProcedure();

  // Write to a variable
  void  Write(String VarName, int Value);

  // Read from a variable
  int   Read(String VarName);

private:
  class Info{
  public:
    int operator==(const Info &other) const{
      return ((Val==other.Val)&&(Depth==other.Depth));
    }
    friend ostream & operator<<(ostream & Out, const Info& outputPair){
      Out<<"Depth: "<<outputPair.Depth<<" Value: "<<outputPair.Val<<endl;
      return Out;
    }
    int Val;
    int Depth;
  };

  StringHash< Stack<Info> *> table;
  Stack<Stack< String> *> stack;
  int CurrentDepth;
};

#endif _SymbolTable_h_
