// *****************************************************
// *                                                   *
// *   keypair.C (MP5)                                 *   
// *                                                   *
// *   Implementation for a key/info class             * 
// *                                                   *
// *   Written 2 March 1999 by Jason Zych              * 
// *    Altered 22 March 1999 -- op>> added            *
// *                                                   * 
// *****************************************************

#include "string.h"
#include "keypair.h"


// KeyPair 
//    - default constructor
//    - initializes object to default values
template <class Ktype, class Etype>
KeyPair<Ktype, Etype>::KeyPair() : key(), info()
{
   // nothing to do here
}


// KeyPair
//    - constructor
//    - parameters : initKey - initial key
//                 : initInfo - initial information 
//    - initializes object to parameter values
template <class Ktype, class Etype>
KeyPair<Ktype, Etype>::KeyPair(Ktype initKey, Etype initInfo) 
	: key(initKey), info(initInfo)
{
   // nothing to do here
}


// GetKey
//    - return type : generic type of key
//    - returns value of key
template <class Ktype, class Etype>
Ktype KeyPair<Ktype, Etype>::GetKey() const
{
   return key; 
}


// GetInfo
//    - return type : generic info type
//    - returns value of information field
template <class Ktype, class Etype>
Etype KeyPair<Ktype, Etype>::GetInfo() const
{
   return info; 
}



// operator==
//    - parameters : comparePair - a KeyPair object to compare to this one
//    - return value : a boolean-valued integer
//    - returns 1 if the KeyPairs are equal, with two KeyPair objects 
//          being considered equal if they have equal keys. Returns 0 otherwise
template <class Ktype, class Etype>
int KeyPair<Ktype, Etype>::operator==(const KeyPair& comparePair) const
{
   return (key == comparePair.key); 
}



// operator!=
//    - parameters : comparePair - a KeyPair object to compare to this one
//    - return value : a boolean-valued integer
//    - returns 1 if the KeyPairs are not equal, with two KeyPair objects 
//          being considered *equal* if they have equal keys. Returns 1 otherwise
template <class Ktype, class Etype>
int KeyPair<Ktype, Etype>::operator!=(const KeyPair& comparePair) const
{
   return (key != comparePair.key); 
}



// operator<
//    - parameters : comparePair - a KeyPair object to compare to this one
//    - return value : a boolean-valued integer
//    - returns 1 if the key of this KeyPair object comes before the key of  
//         the parameter KeyPair object in whatever ordering is appropriate 
//         for the key type of the KeyPair objects; returns 0 otherwise
template <class Ktype, class Etype>
int KeyPair<Ktype, Etype>::operator<(const KeyPair& comparePair) const
{
   return (key < comparePair.key); 
}


// operator>
//    - parameters : comparePair - a KeyPair object to compare to this one
//    - return value : a boolean-valued integer
//    - returns 1 if the key of this KeyPair object comes after the key of
//         the parameter KeyPair object in whatever ordering is appropriate
//         for the key type of the KeyPair objects; returns 0 otherwise
template <class Ktype, class Etype>
int KeyPair<Ktype, Etype>::operator>(const KeyPair& comparePair) const
{
   return (key > comparePair.key); 
}




// operator<< 
//    - parameters : Out - an ostream reference 
//                 : outputPair - a KeyPair to write to output 
//    - return value : an ostream reference
//    - writes the given Pair to the given output stream 
template <class Ktype, class Etype>
ostream & operator<<(ostream & Out, const KeyPair<Ktype, Etype>& outputPair)
{
   Out << "Key: " << outputPair.key << "       Info: " << outputPair.info;
   return Out; 
}



// operator>>
//    - parameters : In - an istream reference
//                 : inputPair - a KeyPair to read from input
//    - return value : an istream reference
//    - reads the given pair from the given input stream
template <class Ktype, class Etype>
istream& operator>>(istream& In, KeyPair<Ktype, Etype>& inputPair)
{
   Ktype tempK; 
   Etype tempE;
   char* wasteString = new char[100];

   // read in and ignore "Key:  "
   In >> wasteString;
   In >> tempK;

   // read in and ignore "    Info: "
   In >> wasteString;
   In >> tempE;

   delete wasteString;

   // assign actual KeyPair object to the read-in values
   inputPair = KeyPair<Ktype, Etype>(tempK, tempE);

   return In;
}


