// *****************************************************
// *                                                   *
// *   wordcounter.h (MP5)                             *
// *                                                   *
// *   Interface for a WordCounter class               *
// *                                                   *
// * Author: Mariusz Zaczek                            *
// * Date:   March 9, 1999                             *
// * Class:  Tu 11am-1pm, Chad Peiper                  *
// *                                                   *
// *****************************************************

#ifndef _WORDCOUNTER
#define _WORDCOUNTER

#include <iostream.h>
#include <stdlib.h>
#include "bstree.h"
#include "string.h"
#include "keypair.h"

class WordCounter
{
  private:

    // A binary search tree object holding objects of type
    // Keypair. The KeyPair objects hold Strings for keys and
    // ints for information.
    BSTree< KeyPair<String, int> > MyTree;


  public:

    // BSTree
    //    - default constructor
    //    - initializes Tree of KeyPairs to default values
    WordCounter();


    // InsertWord
    //    - parameters : s1 - a String value
    //    - Inserts the word as a KeyPair into the tree
    void InsertWord(String s1);


    // PrintFullInfo
    //    - Prints out all of the data of the tree in alphabetical
    //      order - i.e. the Keys and associated Info
    void PrintFullInfo();


    // PrintWordInfo
    //    - parameters : s1 - a String value
    //    - if the string _s1_ is in the tree then it prints out
    //      the string and its associated info, otherwise it prints
    //      out the string and a 0 (zero)
    void PrintWordInfo(String s1);


    // ReadFromFile
    //    - parameters : filename - a char* referring to an input file
    //    - reads data from file and inserts into tree
    void ReadFromFile(char *filename);

    
    // WriteToFile
    //    - parameters : filename - a char referring to an output file
    //    - writes out data from tree (Key and Info) to the file
    void WriteToFile(char *filename);
};

#endif
