// *****************************************************
// *                                                   *
// *   string.h                                        *   
// *                                                   *
// *   Interface for a string class                    *
// *                                                   *
// *   Written 6/16/98 by Jason Zych                   *
// *                                                   * 
// *****************************************************
 
#ifndef MSTRING_H
#define MSTRING_H

#include <stdlib.h>
#include <string.h>
#include <iostream.h>

class String
{
public:

   // String
   //    - default constructor 
   //    - parameters : initString - a pointer to a character array 
   //    - initializes object to the string stored in the character array 
   String(char* initString = NULL);


   // String
   //    - copy constructor
   //    - parameters : origVal - previously allocated String object
   //    - initializes object to be a copy of origVal
   String(const String &origVal);


   // ~String
   //    - destructor
   //    - deletes dynamically allocated memory
   ~String();


   // operator=
   //    - parameters : origVal - previously allocated String object
   //    - return value : reference to String object
   //    - sets object to be a copy of origVal  
   String& operator=(const String& origVal);


   // operator[]
   //    - parameters : index - the index into the String array
   //    - return value : reference to a character object
   //     
   char& operator[](int index) const;

 
   // Substring  
   //    - parameters : startIndex - index in string where substring begins
   //                 : len - length of substring
   //    - return value : a reference to a String
   //    - returns a String which is a substring of this object, starting
   //          at index and of length len 
   String Substring(int startIndex, int len);


   // Length
   //    - return value : integer length of string
   //    - returns the number of characters in the String
   int Length() const;


   // operator+ 
   //    - parameters : firstString - the first string in the conatenation
   //                 : secondString - the second string in the concatenation
   //    - return value : a String value  
   //    - creates a new String formed by concatenating the two parameter
   //           strings in the given order; returns this String
   friend String operator+(const String& leftString, const String& rightString); 


   // operator==
   //    - parameters : leftString - the first of two strings being compared
   //                 : rightString - the second of two string being compared
   //    - return value : a boolean-valued integer
   //    - returns 1 if strings are equal, 0 otherwise 
   friend int operator==(const String& leftString, const String& rightString);
 

   // operator!= 
   //    - parameters : leftString - the first of two strings being compared
   //                 : rightString - the second of two string being compared
   //    - return value : a boolean-valued integer
   //    - returns 1 if strings are not equal, 0 otherwise 
   friend int operator!= (const String& Lhs, const String& Rhs);


   // operator< 
   //    - parameters : leftString - the first of two strings being compared
   //                 : rightString - the second of two string being compared
   //    - return value : a boolean-valued integer
   //    - returns 1 if the first string comes before the second in 
   //         alphabetical order; 0 otherwise 
   friend int operator< (const String& Lhs, const String& Rhs);


   // operator> 
   //    - parameters : leftString - the first of two strings being compared
   //                 : rightString - the second of two string being compared
   //    - return value : a boolean-valued integer
   //    - returns 1 if the first string comes after the second in 
   //         alphabetical order; 0 otherwise
   friend int operator> (const String& Lhs, const String& Rhs);



   // operator<< 
   //    - parameters : Out - an ostream reference 
   //                 : outputString - a String to write to output 
   //    - return value : an ostream reference
   //    - writes the given String to the given output stream 
   friend ostream & operator<<(ostream & Out, const String& outputString);


private:

   int stringLength;    // length of string
   char *stringArray;   // pointer to array holding string characters 

   void Get_Buffer(const unsigned int Max_Length);
};

#endif
