// *************************************************
// *                                               *
// *  window.h (MP3)                               *
// *                                               *
// *  Interface for a window class                 * 
// *                                               *
// *  Written 13 February 1999 by Jason Zych       *
// *                                               *
// *************************************************


#ifndef _WINDOW_H
#define _WINDOW_H

#include "point.h"
#include "string.h"
#include "container.h"


class Window : public Container
{
public:

   // Window
   //    - default constructor
   //    - initializes object to have default values
   Window(); 


   // Window
   //    - constructor
   //    - parameters : theName - name for menubar of window
   //    - initializes object to parameter value 
   Window(String theName); 

 
   // GetName
   //    - returns name of window
   String GetName();


   // Draw
   //    - "draws" this object to the screen (just a text-based description)
   virtual void Draw();


   // Clone
   //    - return value : a Window pointer
   //    - returns a pointer to a new object of this type
   virtual Component* Clone();


private:

   String windowName;
   
};

#endif

   

