// ******************************************************
// *                                                    *
// *  testfns.h (MP3                                    *
// *                                                    *
// *  Driver file for testing MP3 classes               *
// *                                                    *
// *  Written 14 February 1999 by Jason Zych            *
// *                                                    *
// ******************************************************

#include "testfns.h"
#include "point.h"
#include "string.h"
#include "component.h"
#include "container.h"
#include "button.h"
#include "window.h"

#include "easel.h"
#include "panel.h"


// CreateObjectsInSystem
//    - parameters : sys - a reference to the System object
//                      declared in main.C
//    - first part of testing; here is where we create our
//        objects and this is where new code we add gets
//        used 
void CreateObjectsInSystem(System& sys)
{
   Window* w1 = new Window();
   w1->SetLocation(0, 0);
   w1->SetSize(50, 50);
   w1->SetNumComponents(5);
   w1->Add(new Button(String("button 1")));
   w1->Add(new Button(String("button 2")));
   w1->Add(new Button(String("button 3")));
   w1->Add(new Button(String("button 4")));
   w1->Add(new Button(String("button 5")));

   sys.SystemWouldKnow(w1); 


   Easel* e1 = new Easel();
   e1->SetSize(20, 20); 
   e1->SetLocation(0, 60); 
  
   sys.SystemWouldKnow(e1); 

   Panel* p1 = new Panel();
   p1->SetNumComponents(5);
   p1->SetSize(100, 15);
   p1->SetLocation(50, 100);  
   p1->Add(new Easel()); 
   p1->Add(new Button(String("ToClearLeft")));
   p1->Add(new Button(String("ToClearBoth"))); 
   p1->Add(new Button(String("ToClearRight"))); 
   p1->Add(new Easel()); 

   Panel* p2 = new Panel(Point(290, 5), Point(315, 15));
   p2->SetNumComponents(2); 
   p2->SetSize(10, 10);
   p2->SetLocation(300, 0);
   p2->Add(new Easel()); 
   p2->Add(new Button(String("ToClear"))); 
   
   Window* w2 = new Window(); 
   w2->SetNumComponents(3); 
   w2->SetSize(300, 20);
   w2->SetLocation(0, 200); 
   p1->ParentResized(Point(0, 200), Point(300, 220)); 
   //   (actually, the parent was "reassigned", not "resized" here)
   w2->Add(p1); 
   w2->Add(new Button(String("ToToggleBetween"))); 
   p2->ParentResized(Point(0, 200), Point(300, 220)); 
   //   (same here)
   w2->Add(p2);  
   
   sys.SystemWouldKnow(w2);

}


// UseSystem
//    - parameters : sys - a reference to the System object
//                      declared in main.C
//    - second part of testing; this code can be called
//        before or after adding new objects to the
//        system, and will work *without any changes*
//        even though it was written and compiles and
//        runs before you add your two types to the 
//        system. 
void UseSystem(System& sys)
{
   cout << "*************************" << endl; 
   cout << "*  First, draw objects! *" << endl; 
   cout << "*************************" << endl << endl; 
   sys.DrawAll(); 
   cout << endl << endl; 

   cout << "**************************************" << endl; 
   cout << "* Next, check mouse click handling.  *" << endl;   
   cout << "**************************************" << endl << endl; 

   sys.UserClicksWithMouse(0, 0); 
   sys.UserClicksWithMouse(48, 7); 
   sys.UserClicksWithMouse(30, 25); 
   sys.UserClicksWithMouse(10, 40); 
   sys.UserClicksWithMouse(0, 52); 
   sys.UserClicksWithMouse(0, 60); 
   sys.UserClicksWithMouse(10, 70); 
   sys.UserClicksWithMouse(11, 65); 
   sys.UserClicksWithMouse(19, 63); 
   sys.UserClicksWithMouse(15, 100); 
   sys.UserClicksWithMouse(1, 203); 
   sys.UserClicksWithMouse(90, 209); 
   sys.UserClicksWithMouse(55, 215); 
   sys.UserClicksWithMouse(72, 201); 
   sys.UserClicksWithMouse(150, 205); 
   sys.UserClicksWithMouse(190, 217); 
   sys.UserClicksWithMouse(203, 203); 
   sys.UserClicksWithMouse(220, 219); 
   sys.UserClicksWithMouse(298, 215); 
   sys.UserClicksWithMouse(95, 210); 
  
   cout << endl << endl; 

   cout << "********************************" << endl;
   cout << "*  Finally, redraw objects!    *" << endl;
   cout << "*   Points are now on easels.  *" << endl; 
   cout << "********************************" << endl << endl;
   sys.DrawAll();
   cout << endl << endl;

}


