// *************************************************
// *                                               *
// *  panel.h (MP3)                                *
// *                                               *
// *  Interface for a panel class                  * 
// *                                               *
// *  Written 13 February 1999 by Jason Zych       *
// *                                               *
// *************************************************

#ifndef _PANEL_H
#define _PANEL_H

#include "point.h"
#include "container.h"


class Panel : public Container
{
public:


   // Panel
   //    - default constructor
   //    - initializes object to have default values
   Panel();


   // Panel
   //    - constructor
   //    - parameters : initLL - the initializing lower left point
   //                                of parent window
   //                 : initUR - the initializing upper right point
   //                                of parent window 
   //    - initializes object to parameter values 
   Panel(Point initLL, Point initUR); 


   // ParentResized
   //    - parameters : setLL - the new lower left point of parent window
   //                 : setUR - the new upper right point of parent window
   //    - assigns the stored parent boundary coords to parameter values
   void ParentResized(Point setLL, Point setUR);

 

   // Draw
   //    - "draws" this object to the screen (just a text-based description)
   virtual void Draw();


   // Clone
   //    - return value : a Panel pointer
   //    - returns a pointer to a new object of this type
   virtual Component* Clone();


private:

   Point parentLowerLeft;     // lower left corner of parent window
   Point parentUpperRight;    // upper right corner of parent window
   
};

#endif

   

