// *************************************************
// *                                               *
// *  easel.h (MP3)                                *
// *                                               *
// *  Interface for an easel class                 *
// *                                               *
// *  Written 13 February 1999 by Jason Zych       *
// *                                               *
// *************************************************


#ifndef _EASEL_H
#define _EASEL_H

#include "component.h"
#include "array.h"
#include "point.h"

class Easel : public Component
{
public:

   // Easel
   //    - default constructor
   //    - initializes object to have default values
   Easel(); 


   // Draw
   //    - "draws" this object to the screen (just a text-based description)
   virtual void Draw();


   // Clone
   //    - return value : a Easel pointer
   //    - returns a pointer to a new object of this type
   virtual Component* Clone(); 


   // HandleMouseClick
   //    - parameters : locationPoint - location of mouse click
   //    - processes the "mouse click" event. If mouse click is on
   //        an object that does not support any mouse-click-activated
   //        operations, then nothing will happen.
   virtual void HandleMouseClick(Point locationPoint);


private:

   Array<Point> ptArray;   // array to hold points of easel
   int lastPtUsed;         // index to the last point stored in array 

};

#endif

   

