// ****************************************************
// *                                                  *
// *  simsys.h (MP3)                                  *
// *                                                  *
// *  Interface for a simulated run-time environment  *
// *      (i.e. a simulated "system")                 *
// *                                                  *
// *  Written 14 February 1999 by Jason Zych          *
// *                                                  *
// ****************************************************


#ifndef _SIMSYS_H
#define _SIMSYS_H

#include "component.h"
#include "array.h"

class System
{
public:

   // System
   //    - default constructor
   //    - initializes object to have default values
   System(); 


   // System
   //    - copy constructor
   //    - parameters : origVal - previously allocated System object 
   //    - initializes object to be a coy of origVal
   System(const System& origVal);


   // ~System
   //    - destructor
   //    - deletes dynamically allocated memory
   ~System();


   // operator=
   //    - parameters : origVal - previously allocated System object 
   //    - return value : reference to this object
   //    - sets object to be a coy of origVal
   System& System::operator=(const System& origVal);


   // Draw
   //    - "draws" the object collection to the screen 
   //             (just their text-based descriptions)
   void DrawAll();


   // SystemWouldKnow 
   //    - parameters : addingComp - pointer to new component to add
   //    - adds this top-level object to the system collection of
   //       objects 
   void SystemWouldKnow(Component* addingComp); 


   // UserClicksWithMouse 
   //    - parameters : xLoc - x-coordinate of mouse click
   //                 : yLoc - y-coordinate of mouse click
   //    - processes the "mouse click" event on the internal
   //        objects. If mouse click is on an object that does 
   //        not support any mouse-click-activated operations, 
   //        or if is not on an object, then nothing will happen.
   void UserClicksWithMouse(int xLoc, int yLoc); 


private:

   Array<Component*> compArray;
   int usedSoFar;
};

#endif

   

