// *************************************************
// *                                               *
// *  panel.h (MP3)                                *
// *                                               *
// *  Interface for a panel class                  *
// *                                               *
// *  Author: Mariusz Zaczek                       *
// *  Date:   February 17, 1999                    *
// *  Class:  Tu 11-1 Chad Piper                   *
// *************************************************

#ifndef _PANEL_H
#define _PANEL_H

#include "point.h"
#include "container.h"


class Panel : public Container
{
  private:
    Point FirstObject;
    Point SecondObject;

  public:

    // Panel
    //    - default constructor
    //    - does nothing for this class since Point class 
    //      intializes the points.
    Panel(); 


    // Panel
    //    - constructor
    //    - parameters : One - 1st corner point of the panel
    //                   Two - 2nd corner point of the panel
    //    - initializes points to parameter values
    Panel(Point One, Point Two); 

 
    // ParentResized
    //    - parameters : One - 1st corner point of the panel
    //                   Two - 2nd corner point of the panel
    void ParentResized(Point One, Point Two);

    // Draw
    //    - "draws" this object to the screen (just a text-based description)
    virtual void Draw();


    // Clone
    //    - return value : a Panel pointer
    //    - returns a pointer to a new object of this type
    virtual Component* Clone();
   
};

#endif

   

