// *************************************************
// *                                               *
// *  easel.C (MP3)                                *
// *                                               *
// *  Implementation for a easel class             *
// *                                               *
// *  Author: Mariusz Zaczek                       *
// *  Date:   February 17, 1999                    *
// *  Class:  Tu 11-1 Chad Piper                   *
// *************************************************

#include <iostream.h>
#include "easel.h"


// Easel
//    - default constructor
//    - initializes object to have default values
Easel::Easel() : Component()
{
  pointArray.SetBounds(0,19);
  numPoints = 0;
} 


// HandleMouseClick
//    - parameters : locationPoint - location of mouse click   
//    - processes the "mouse click" event. If mouse click is on
//        an object that does not support any mouse-click-activated
//        operations, then nothing will happen.   
void Easel::HandleMouseClick(Point locationPoint)
{
   if (Contains(locationPoint))
   {
     pointArray[numPoints] = locationPoint;
     numPoints++;

     // if the current array is full then double its size   
     if(numPoints == pointArray.Size())
       pointArray.SetBounds(0,2*numPoints);
   }
}   
    
  
// Draw
//    - "draws" this object to the screen (just a text-based description)
void Easel::Draw()
{
   cout << "This easel contains the following points:" << endl;

   for(int i=0 ; i < numPoints ; i++)
     cout << "(" << pointArray[i].XCoord() << ", " 
          << pointArray[i].YCoord() << ")" << endl;
}


// Clone
//    - return value : a Button pointer
//    - returns a pointer to a new object of this type
Component* Easel::Clone()
{
   return new Easel(*this);
} 
