// *************************************************
// *                                               *
// *  container.h (MP3)                            *
// *                                               *
// *  Interface for an abstract container class    * 
// *                                               *
// *  Written 13 February 1999 by Jason Zych       *
// *                                               *
// *************************************************


#ifndef _CONTAINER_H
#define _CONTAINER_H

#include "point.h"
#include "array.h"
#include "component.h"


class Container : public Component
{
public:

   // Container
   //    - default constructor
   //    - initializes object to have default values
   Container(); 


   // Container
   //    - copy constructor
   //    - parameters : origVal - previously allocated Container object
   //    - initializes object to be a copy of origVal
   Container(const Container& origVal);


   // ~Container
   //    - destructor
   //    - deletes dynamically allocated memory
   virtual ~Container();


   // operator= 
   //    - parameters : origVal - previously allocated Container object
   //    - return value : reference to this object
   //    - sets object to be a copy of origVal
   Container& operator=(const Container& origVal);



   // SetSize
   //    - parameters : width - the width (x-range) this object should have
   //                 : height - the height (y-range) this object should have
   //    - sets interior data so that the appropriate width and height
   //        are represented. Appropriately change size and location for
   //        all interior components
   virtual void SetSize(int width, int height);



   // SetLocation
   //    - parameters : xLoc - x-location of new point
   //                 : yLoc - y-location of new point
   //    - sets interior data so that lower-left-hand corner of component
   //        is at parameter location. Appropriately change location of
   //        all interior components.
   virtual void SetLocation(int xLoc, int yLoc);



   // SetNumComponents
   //    - parameters : numComponents - the number of components 
   //                        you wish to add to this container
   //    - container adjusted to have space for numComponents components
   //       If this results in not enough space for all current components,
   //       the extra components are deleted. 
   void SetNumComponents(int numComponents);


   // Add
   //    - parameters : newestComp - a pointer to a component to add to 
   //                                  the container
   //    - adds component to container and returns 0; if container is 
   //                full, component is deleted and -1 is returned
   int Add(Component* newestComp); 


   // HandleMouseClick
   //    - parameters : locationPoint - location of mouse click
   //    - processes the "mouse click" event. If mouse click is on
   //        an object that does not support any mouse-click-activated
   //        operations, then nothing will happen.
   virtual void HandleMouseClick(Point locationPoint);


protected:


   // DrawHelper()
   //    - draws all components
   virtual void DrawHelper();


   Array<Component*>  compArray;
   int lastCompAdded;
   
};

#endif

   

