// ******************************************************
// *                                                    *
// *  mp2fns.h (MP2)                                    *
// *                                                    *
// *  Function prototypes for MP2 array search and      *
// *    traversal functions                             *
// *                                                    *
// *  Written 4 Feb 1999 by Jason Zych                  *
// *                                                    *
// ******************************************************

#ifndef _MP2FNS_H
#define _MP2FNS_H

#include "array.h"
#include "named.h"
#include "string.h"


// RetrieveFromArray
//    - parameters : searchString - the string we are trying to match against
//                 : dataArray - the array which contains objects
//                 : searchItem - a reference to a generic-type variable
//                                  where we will store a value
//    - return value : integer value serving as a boolean
//    - searches the Array for a NamedItem object with first name equal
//         to searchString. If found, searchItem is set to be equal to that 
//         NamedItem's item, and 1 is returned. Otherwise, 0 is returned. 
template <class Etype>
int RetrieveFromArray(String searchString,
           const Array<NamedItem<Etype> >& dataArray, Etype& searchItem);



// ReturnFullName
//    - parameters : dataItem - a NamedItem object to extract names from
//    - return value : a name String
//    - returns a String that is the concatentation of the first and
//        last names of dataItem with a space in-between 
template <class Etype>
String ReturnFullName(const NamedItem<Etype>& dataItem);

#endif



