/* +++++[  MP2 - NamedItem CLASS  ]++++++++++++++++++++++++++++++++++++
   +                                                                  +
   +  Name:   Mariusz Zaczek                                          +
   +  Class:  Tu 11-1                                                 +
   +  Date:   2-6-1999                                                +
   +                                                                  +
   +                                                                  +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

#ifndef NAMED_H
#define NAMED_H

#include "string.h"

/* +++++[ Class NamedItem  ]+++++++++++++++++++++++++++++++++++++++++++
   +                                                                  +
   +  This is a template class which takes Etype types and is used to +
   +  keep track of the names ( First and Last ) as well as the Item  +
   +  of a NamedItem object. This particular files contains the class +
   +  declarations...the actual code can be found in the named.C file +
   +                                                                  +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
template<class Etype>
class NamedItem
{
  private:
    String *FirstName;    /* Pointer to a String  - First Name */
    String *LastName;     /* Pointer to a String  - Last Name  */
    Etype Item;           /* Generic type of Item              */

  public:

    /* +++++[  NamedItem() ]+++++++++++++++++++++++++++++++++++++
       +                                                        +
       +   - parameters : none                                  +
       +                                                        +
       +   - default constructor                                +
       +   - initializes object to default values               +
       +   - dynamically allocates FirstName and LastN          +
       +                                                        +
       ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
    NamedItem();



    /* ++++[ NamedItem(char *First, char *Last, Etype object) ]++
       +                                                        +
       +   - parameters : char *First - pointer to a char       +
       +                  char *Last  - pointer to a char       +
       +                  Etype object - a generic type object  +
       +                                                        +
       +   - default constructor                                +
       +   - initializes object to default values               +
       +   - dynamically allocates FirstName and LastName       +
       +                                                        +
       ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
    NamedItem(char *First, char *Last, Etype object);



    /* ++++[ NamedItem(String First,String Last, Etype object) ]+
       +                                                        +
       +   - parameters : String First - A string               +
       +                  String Last - A string                +
       +                  Etype object - a generic type object  +
       +                                                        +
       +   - default constructor                                +
       +   - initializes object to default values               +
       +   - dynamically allocates FirstName and LastName       +
       +                                                        +
       ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */           
    NamedItem(String First, String Last, Etype object);



    /* +++++[  NamedItem(const NamedItem<Etype> &source) ]+++++++
       +                                                        +
       +   - parameters : const NamedItem<Etype> &source        +
       +            - a constant reference to an NamedItem      +
       +              object of Etype                           +
       +            - source is a previously allocated          +
       +              NamedItem<Etype> obj                      +
       +                                                        +
       +   - copy constructor                                   +
       +   - Initializes a object to a copy of source           +
       +                                                        +
       ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
    NamedItem(const NamedItem<Etype> &source);



    /* +++++[  ~NamedItem()  ]+++++++++++++++++++++++++++++++++++
       +                                                        +
       +   - parameters : none                                  +
       +                                                        +
       +   - destructor - deletes dynamically allocated memory  +
       +                   of FirstName and LastName            +
       +                                                        +
       ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */ 
   ~NamedItem();



    /* +++++[  operator=(const NamedItem <Etype> &source)  ]+++++
       +                                                        +
       +   - parameters : const NamedItem<Etype> &source        +
       +                                                        +
       +   - operator =   - used to make copies of              +
       +                    NamedItem<Etype> objects            +
       +                                                        +
       ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
    NamedItem<Etype> &operator=(const NamedItem<Etype> &source);



    /* +++++[ GetFirstName() ]+++++++++++++++++++++++++++++++++++
       +                                                        +
       +   - parameters : none                                  +
       +                                                        +
       +   - returns a constant reference to a string object    +
       +                                                        +
       ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */   
    const String& GetFirstName();



    /* +++++[ GetlASTName() ]++++++++++++++++++++++++++++++++++++
       +                                                        +
       +   - parameters : none                                  +
       +                                                        +
       +   - returns a constant reference to a string object    +
       +                                                        +
       ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */      
    const String& GetLastName();



    /* +++++[ GetItem() ]+++++++_+++++++++++++++++++++++++++++++++
       +                                                        +
       +   - parameters : none                                  +
       +                                                        +
       +   - returns a constant reference to a string object    +
       +                                                        +
       ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */      
    const Etype& GetItem();
};

#endif NAMED_H
