/* +++++[  MP1 - TEE CLASS ]+++++++++++++++++++++++++++++++++++++++++++++
   +                                                                    +
   +  Name:   Mariusz Zaczek                                            +
   +  Class:  Tu 11-1                                                   +
   +  Date:   2-1-1999                                                  +
   +                                                                    +
   +  This is the Tee class code file used by MP1. It contains all of   +
   +  the functions declared in the tee.h header file.                  +
   +                                                                    +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

#include <iostream.h>
#include "tee.h"

/* +++++[  Tee()  ]++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                                    +
   +   - parameters : none                                              +
   +                                                                    +
   +   - default constructor                                            +
   +   - initializes object to default values                           +
   +                                                                    +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
Tee::Tee()
{
  /* Set all entrances to be open */
  entrance[0] = 1; 
  entrance[1] = 1; 
  entrance[2] = 1;
  
  /*  writing    *.*
                 *..
                 *.*
      to the draw array */ 

  for (int i = 0; i<=2; i++)
  {
    drawArray[i][0] = '*';
    drawArray[i][1] = '.';
  }

  drawArray[0][2] = drawArray[2][2] = '*';
 
  drawArray[1][2] = '.';     

  /* Set original orientation of Tee to 0 */
  orientation = 0; 
}

/* +++++[  OpenEntrance()  ]+++++++++++++++++++++++++++++++++++++++++++++
   +                                                                    +
   +   - function type: void                                            +
   +                                                                    +
   +   - parameters : enterNum - the number of the entrance we          +
   +       wish to open                                                 +
   +                                                                    +
   +   - if enterNum is a legal entrance number, close the entrance;    +
   +     otherwise, say it is illegal and return                        +
   +                                                                    +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Tee::OpenEntrance(int enterNum)
{
  if ((enterNum < 0) || (enterNum > 2))
    cout << "That is not a legal entrance number for this object!" << endl; 
  else
    entrance[enterNum] = 1;
}


/* +++++[  CloseEntrance()  ]++++++++++++++++++++++++++++++++++++++++++++
   +                                                                    +
   +   - function type: void                                            +
   +                                                                    +
   +   - parameters : enterNum - the number of the entrance we          +
   +       wish to close                                                +
   +                                                                    +
   +   - if enterNum is a legal entrance number, close the entrance;    +
   +     otherwise, say it is illegal and return                        +
   +                                                                    +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Tee::CloseEntrance(int enterNum)
{
   if ((enterNum < 0) || (enterNum > 2))
      cout << "That is not a legal entrance number for this object!" << endl; 
   else
      entrance[enterNum] = 0;
}


/* +++++[  Imprint()  ]++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                                    +
   +   - function type: void                                            +
   +                                                                    +
   +   - parameters : picArray - array to which we write the appropriate+
   +                     symbols to represent this tubing type          +
   +                : rLoc - row Coord of this object in placement array+  
   +                : cLoc - column Coord of this object in placement   +
   +                      array                                         +
   +                                                                    +
   +                                                                    +
   +   -  writes the character group which represents this type to      +
   +        the appropriate location in the picture array               +
   +                                                                    +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Tee::Imprint(char picArray[9][9], int rLoc, int cLoc)
{
   for (int i = 0; i<=2; i++)
      for (int j = 0; j<=2; j++)
         picArray[3*rLoc + i][3*cLoc + j] = drawArray[i][j];
}



/* +++++[  Rotate()  ]+++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                                    +
   +   - function type: void                                            +
   +                                                                    +
   +   - rotates object to next orientation point -- in                 +
   +      this case, 90 degrees counter-clockwise.                      +
   +                                                                    +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Tee::Rotate()
{
   if (orientation == 0)
   {
      drawArray[2][1] = '*';
      drawArray[1][0] = '.';
   }
   else if (orientation == 90)
   {
      drawArray[1][2] = '*';
      drawArray[2][1] = '.';
   }
   else if (orientation == 180)
   {
      drawArray[0][1] = '*';
      drawArray[1][2] = '.';
   }
   else if (orientation == 270)
   {
      drawArray[1][0] = '*';
      drawArray[0][1] = '.';
   }
   else
      cout << "Error in Tee::Rotate(): corrupted orientation" << endl;

   orientation += 90;
   if (orientation >= 360)
      orientation -= 360;
} 
