/* +++++[  MP1 - STRAIGHT CLASS ]++++++++++++++++++++++++++++++++++++++++
   +                                                                    +
   +  Name:   Mariusz Zaczek                                            +
   +  Class:  Tu 11-1                                                   +
   +  Date:   2-1-1999                                                  +
   +                                                                    +
   +  This is the Straight class code file which contains all of the    +
   +  function declared in the straight.h file and used by MP1.         +
   +                                                                    +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

#include <iostream.h>
#include "straight.h"

/* +++++[  Straight()  ]+++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                                    +
   +   - parameters : none                                              +
   +                                                                    +
   +   - default constructor                                            +
   +   - initializes object to default values                           +
   +                                                                    +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
Straight::Straight()
{
  /* Set all entrances to be open */
  entrance[0] = 1; 
  entrance[1] = 1; 
  
  /* writing    ***
                ...
                ***
     to the draw array */

  for (int i = 0; i<=2; i++)
  {
    drawArray[0][i] = drawArray[2][i] = '*';
    drawArray[1][i] = '.';
  }

  /* Set original orientation of Tee to 0 */
  orientation = 0; 
}


/* +++++[  OpenEntrance()  ]+++++++++++++++++++++++++++++++++++++++++++++
   +                                                                    +
   +   - function type: void                                            +
   +                                                                    +
   +   - parameters : enterNum - the number of the entrance we          +
   +       wish to open                                                 +
   +                                                                    +
   +   - if enterNum is a legal entrance number, close the entrance;    +
   +     otherwise, say it is illegal and return                        +
   +                                                                    +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Straight::OpenEntrance(int enterNum)
{
   if ((enterNum < 0) || (enterNum > 1))
      cout << "That is not a legal entrance number for this object!" << endl; 
   else
      entrance[enterNum] = 1;
}


/* +++++[  CloseEntrance()  ]++++++++++++++++++++++++++++++++++++++++++++
   +                                                                    +
   +   - function type: void                                            +
   +                                                                    +
   +   - parameters : enterNum - the number of the entrance we          +
   +       wish to close                                                +
   +                                                                    +
   +   - if enterNum is a legal entrance number, close the entrance;    +
   +     otherwise, say it is illegal and return                        +
   +                                                                    +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Straight::CloseEntrance(int enterNum)
{
   if ((enterNum < 0) || (enterNum > 1))
      cout << "That is not a legal entrance number for this object!" << endl; 
   else
      entrance[enterNum] = 0;
}

/* +++++[  Imprint()  ]++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                                    +
   +   - function type: void                                            +
   +                                                                    +
   +   - parameters : picArray - array to which we write the appropriate+
   +                     symbols to represent this tubing type          +
   +                : rLoc - row Coord of this object in placement array+  
   +                : cLoc - column Coord of this object in placement   +
   +                      array                                         +
   +                                                                    +
   +                                                                    +
   +   -  writes the character group which represents this type to      +
   +        the appropriate location in the picture array               +
   +                                                                    +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Straight::Imprint(char picArray[9][9], int rLoc, int cLoc)
{
   for (int i = 0; i<=2; i++)
      for (int j = 0; j<=2; j++)
         picArray[3*rLoc + i][3*cLoc + j] = drawArray[i][j];
}

/* +++++[  Rotate()  ]+++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                                    +
   +   - function type: void                                            +
   +                                                                    +
   +   - rotates object to next orientation point -- in                 +
   +      this case, 90 degrees counter-clockwise.                      +
   +                                                                    +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */ 
void Straight::Rotate()
{
   if (orientation == 0)
   {
      drawArray[1][0] = drawArray[1][2] = '*';
      drawArray[0][1] = drawArray[2][1] = '.';
   }
   else if (orientation == 90)
   {
      drawArray[1][0] = drawArray[1][2] = '.';
      drawArray[0][1] = drawArray[2][1] = '*';
   }
   else
      cout << "Error in Straight::Rotate(): corrupted orientation" << endl;

   if (orientation == 0)
     orientation += 90;
   else     
     orientation += 270;

   if (orientation >= 360)
      orientation -= 360;
} 
