// ******************************************************
// *                                                    *
// *  tee.C (MP1)                                       *
// *                                                    *
// *  Implementation for a class which models a         *
// *    tee-shaped tubing piece                         *
// *                                                    *
// *  Written 28 Jan 1999 by Jason Zych                 *
// *                                                    *
// ******************************************************

#include <iostream.h>
#include "tee.h"


// Tee
//    - default constructor
//    - initializes object to default values
Tee::Tee()
{
   for (int i = 0; i<=2; i++)
      entrance[i] = 1;  // entrances open 
  
   // writing    *.*
   //            *..
   //            *.*
   // to the draw array 

   for (i = 0; i<=2; i++)
   {
      drawArray[i][0] = '*';
      drawArray[i][1] = '.';
   }
   drawArray[0][2] = drawArray[2][2] = '*';
   drawArray[1][2] = '.';
 
   orientation = 0; 
}


// OpenEntrance
//    - parameters : enterNum - the number of the entrance
//                     we wish to open
//    - if enterNum is a legal entrance number, open the 
//        entrance; otherwise, say it is illegal and return
void Tee::OpenEntrance(int enterNum)
{
   if ((enterNum < 0) || (enterNum > 2))
      cout << "That is not a legal entrance number for this object!" << endl; 
   else
      entrance[enterNum] = 1;
}


// CloseEntrance
//    - parameters : enterNum - the number of the entrance
//                     we wish to close 
//    - if enterNum is a legal entrance number, close the 
//        entrance; otherwise, say it is illegal and return
void Tee::CloseEntrance(int enterNum)
{
   if ((enterNum < 0) || (enterNum > 2))
      cout << "That is not a legal entrance number for this object!" << endl; 
   else
      entrance[enterNum] = 0;
}


// Imprint
//    - parameters : picArray - array to which we write the appropriate
//                       symbols to represent this tubing type 
//                 : xLoc - x-Coord of this object in placement array
//                 : yLoc - y-Coord of this object in placement array 
//    - writes the character group which represents this type to
//        the appropriate location in the picture array 
void Tee::Imprint(char picArray[9][9], int xLoc, int yLoc)
{
   for (int i = 0; i<=2; i++)
      for (int j = 0; j<=2; j++)
         picArray[3*xLoc + i][3*yLoc + j] = drawArray[i][j];
}



// Rotate
//    - rotates object to next orientation point -- in 
//       this case, 90 degrees counter-clockwise. 
void Tee::Rotate()
{
   if (orientation == 0)
   {
      drawArray[1][0] = '.';
      drawArray[2][1] = '*';
   }
   else if (orientation == 90)
   {
      drawArray[1][2] = '*';
      drawArray[2][1] = '.';
   }
   else if (orientation == 180)
   {
      drawArray[0][1] = '*';
      drawArray[1][2] = '.';
   }
   else if (orientation == 270)
   {
      drawArray[1][0] = '*';
      drawArray[0][1] = '.';
   }
   else
      cout << "Error in Tee::Rotate(): corrupted orientation" << endl;


   orientation += 90;
   if (orientation >= 360)
      orientation -= 360;
} 
