/* +++++[  MP1  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                                       +
   +  Name:   Mariusz Zaczek                                               +
   +  Class:  Tu 11-1                                                      +
   +  Date:   2-1-1999                                                     +
   +                                                                       +
   +  This is the main file, containing main(), where the Fill, Cross,     +
   +  Bend, Tee and Straight classes are used to generate an image of      +
   +  pipe connections.                                                    +
   +                                                                       +
   +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
#include <stddef.h>
#include <iostream.h>
#include "fill.h"
#include "cross.h"
#include "bend.h"
#include "tee.h"
#include "straight.h"
#include "indicator.h"
#include "print.h"

/* Main part of code */
int main( )
{
  /* Dynamically allocated arrays of 10 elements corresponding to the
     Fill, Cross, Bend, Tee and Straight classes. */
  Fill     *fillArray     = new Fill[10];
  Cross    *crossArray    = new Cross[10];
  Bend     *bendArray     = new Bend[10];
  Tee      *teeArray      = new Tee[10];
  Straight *straightArray = new Straight[10];

  /* A counter variable initialized to zero for each type of class 
     object to be used. */
  int fillCount     = 0,
      crossCount    = 0,
      bendCount     = 0, 
      teeCount      = 0,
      straightCount = 0;

  /* A 3x3 array of indicator pointers. */
  Indicator *indicatorPtr[3][3];

  /* Define the Bend object which is rotated once from orig. position. */
  bendArray[1].Rotate();

  /* Define the Straight object which is rotated once from orig. position.*/
  straightArray[1].Rotate(); 

  /* Traverse the 3x3 array inserting appropriate shapes. */
  indicatorPtr[0][0] = new Indicator('b',bendCount++);
   
  indicatorPtr[0][1] = new Indicator('b',bendCount++);

  indicatorPtr[0][2] = new Indicator('b',bendCount++);

  /* Define the Tee object which is rotated once from orig. position. */
  teeArray[0].Rotate();

  indicatorPtr[1][0] = new Indicator('t',teeCount++);

  indicatorPtr[1][1] = new Indicator('c',crossCount++);

  indicatorPtr[1][2] = new Indicator('c',crossCount++);

  indicatorPtr[2][0] = new Indicator('f',fillCount++);

  /* Define a new Straight object which is rotated once from orig.position. */
  straightArray[0].Rotate();

  indicatorPtr[2][1] = new Indicator('s',straightCount++);

  indicatorPtr[2][2] = new Indicator('t',teeCount++);

  /* Declare a 9x9 character array. */
  char picArray[9][9];

  /* Loop through the 3x3 array and determine which shape is required for 
     each position. Take this shape and call its Imprint() function and
     the character array (from above) to "imprint" the shape on this array. */
  for(int i=0;i<=2;i++)
    for(int j=0;j<=2;j++)
    {
      if(indicatorPtr[i][j]->GetClassChoice() == 'f')
        fillArray[indicatorPtr[i][j]->GetClassIndex()].Imprint(picArray,i,j);
      else if(indicatorPtr[i][j]->GetClassChoice() == 'c') 
        crossArray[indicatorPtr[i][j]->GetClassIndex()].Imprint(picArray,i,j);
      else if(indicatorPtr[i][j]->GetClassChoice() == 'b')
        bendArray[indicatorPtr[i][j]->GetClassIndex()].Imprint(picArray,i,j);
      else if(indicatorPtr[i][j]->GetClassChoice() == 't')
        teeArray[indicatorPtr[i][j]->GetClassIndex()].Imprint(picArray,i,j);
      else if(indicatorPtr[i][j]->GetClassChoice() == 's')
        straightArray[indicatorPtr[i][j]->GetClassIndex()].Imprint(picArray,i,j); 
      else
        cout << " Error: No shape selected." << endl;
    }

  /* Display the number of object used for a particular shape. */
  cout << "We have " << fillCount     << " Fill objects in our grid.\n"
       << "We have " << crossCount    << " Cross objects in our grid.\n"
       << "We have " << bendCount     << " Bend objects in our grid.\n"
       << "We have " << teeCount      << " Tee objects in our grid.\n"
       << "We have " << straightCount << " Straight objects in our grid.\n" 
       << endl;
 
  /* Print the picture array by calling the Print() function. */
  Print(picArray);
 
  /* Free the dynamically allocated shape arrays. */
  delete [] fillArray;
  delete [] crossArray;
  delete [] bendArray;
  delete [] teeArray;
  delete [] straightArray;

  /* Free the dynamically allocated indicator pointers. */
  for(int a=0;a<=2;a++)
    for(int b=0;b<=2;b++)
      delete indicatorPtr[a][b];

  return 0;
}
