// ******************************************************
// *                                                    *
// *  indicator.h (MP1)                                 *
// *                                                    *
// *  Interface for a class which makes reference       *
// *    to data at particular indices in particular     *
// *    arrays                                          *
// *                                                    *
// *  Written 28 Jan 1999 by Jason Zych                 *
// *                                                    *
// ******************************************************


class Indicator
{
public:
   
   // Indicator
   //    - default constructor
   //    - initializes object to default values 'n' and '-1'
   //        which are invalid for real objects. This allows
   //        us to tell if an official assignment has been
   //        made or not.
   Indicator(); 


   // Indicator
   //    - constructor
   //    - parameters : classChoice - character to determine array
   //                 : classIndex -  integer to determine array index
   //    - initialized object with values passed in as parameters
   Indicator(char classChoice, int classIndex);


   // GetClassChoice
   //    - return value : stored class choice character
   //    - returns the class choice of this indicator
   char GetClassChoice(); 
   

   // GetClassIndex
   //    - return value : stored class index value
   //    - returns the class index of this indicator
   int GetClassIndex();

private:

   char choiceOfTubing;     // indicates the class of object that we
                            //  want here
   int orderAllocated;   // indicates the order of allocation of this
                         //  object with regards to its type. That is,
                         //  if this was the first object allocated to
                         //  represent a Fill object, the int would 
                         //  be 0; if it were the second, the int would
                         //  be 1, and so on.   

};


