// ******************************************************
// *                                                    *
// *  indicator.C (MP1)                                 *
// *                                                    *
// *  Implementation for a class which makes reference  *
// *    to data at particular indices in particular     *
// *    arrays                                          *
// *                                                    *
// *  Written 28 Jan 1999 by Jason Zych                 *
// *                                                    *
// ******************************************************

#include "indicator.h"

// Indicator
//    - default constructor
//    - initializes object to default values 'n' and '-1'
//        which are invalid for real objects. This allows
//        us to tell if an official assignment has been
//        made or not.
Indicator::Indicator()
{
   choiceOfTubing = 'n';
   orderAllocated = -1; 
}


// Indicator
//    - constructor
//    - parameters : classChoice - character to determine array
//                 : classIndex -  integer to determine array index
//    - initialized object with values passed in as parameters
Indicator::Indicator(char classChoice, int classIndex) 
{
   choiceOfTubing = classChoice; 
   orderAllocated = classIndex; 
}


// GetClassChoice
//    - return value : stored class choice character
//    - returns the class choice of this indicator
char Indicator::GetClassChoice() 
{
   return choiceOfTubing; 
}


// GetClassIndex
//    - return value : stored class index value
//    - returns the class index of this indicator
int Indicator::GetClassIndex()
{
   return orderAllocated;  
}


