// ******************************************************
// *                                                    *
// *  cross.C (MP1)                                     *
// *                                                    *
// *  Implementation for a class which models a         *
// *    cross-shaped tubing piece                       *
// *                                                    *
// *  Written 28 Jan 1999 by Jason Zych                 *
// *                                                    *
// ******************************************************

#include <iostream.h>
#include "cross.h"


// Cross
//    - default constructor
//    - initializes object to default values
Cross::Cross()
{
   for (int i = 0; i<=3; i++)
      entrance[i] = 1;  // entrances open 
  
   // writing    *.*
   //            ...
   //            *.*
   // to the draw array 

   // the corners are asterisks
   drawArray[0][0] = drawArray[2][2] = '*';
   drawArray[2][0] = drawArray[0][2] = '*';

   // the rest are dots
   for (int i=0; i<=2; i++)
   {
      drawArray[i][1] = '.';
      drawArray[1][i] = '.';
   }

}



// OpenEntrance
//    - parameters : enterNum - the number of the entrance
//                     we wish to open
//    - if enterNum is a legal entrance number, open the 
//        entrance; otherwise, say it is illegal and return
void Cross::OpenEntrance(int enterNum)
{
   if ((enterNum < 0) || (enterNum > 3))
      cout << "That is not a legal entrance number for this object!" << endl; 
   else
      entrance[enterNum] = 1;
}




// CloseEntrance
//    - parameters : enterNum - the number of the entrance
//                     we wish to close 
//    - if enterNum is a legal entrance number, close the 
//        entrance; otherwise, say it is illegal and return
void Cross::CloseEntrance(int enterNum)
{
   if ((enterNum < 0) || (enterNum > 3))
      cout << "That is not a legal entrance number for this object!" << endl; 
   else
      entrance[enterNum] = 0;
}


// Imprint
//    - parameters : picArray - array to which we write the appropriate
//                       symbols to represent this tubing type 
//                 : rLoc - row Coord of this object in placement array
//                 : cLoc - column Coord of this object in placement array 
//    - writes the character group which represents this type to
//        the appropriate location in the picture array 
void Cross::Imprint(char picArray[9][9], int rLoc, int cLoc)
{
   for (int i = 0; i<=2; i++)
      for (int j = 0; j<=2; j++)
         picArray[3*rLoc + i][3*cLoc + j] = drawArray[i][j];
}



