/* ++[   MP6 - student.h  ]++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + Zaczek, Mariusz                                            +
   + CS 223 - Monday 11:00am - 1:00 pm                          +
   + 4/25/98                                                    +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

#ifndef STUDENT_H
#define STUDENT_H

/* ++[ Class - Student ]+++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + Student Class (BASE)                                       +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

class Student
{
  /* Overloaded << operator */
  friend ostream &operator<<(ostream &, Student *);

private:
  /* Variables */
  long ssn;
  int major;
  int grade;
  double units;
  char name[256];

public:
  /* Contructor Default */
  Student();
  
  /* Constructor */
  Student(long,char *,int,double,int);

  /* get_grade function */
  virtual int get_grade();
  
  /* Print function */
  virtual void print(long s, char *n, int m, double u, int g);
 
  /* Change grade function */
  virtual void change_grade(int new_grade);

  /* Change units function */
  virtual void change_units(double new_units);
};

/* ++[ Graduate - Student public ]+++++++++++++++++++++++++++++++
   +                                                            +
   + Graduate Class (derived)                                   +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
class Graduate : public Student
{
private:
  /* variables */
  int status;

public:
  /* Print function */
  virtual void print(long s, char *n, int m, double u, int g);
  
  /* Graduate constructor */
  Graduate(long,char *,int,double,int,int);
//  int get_status();
};

/* ++[ Undergraduate - Student public ]++++++++++++++++++++++++++
   +                                                            +
   + Undergraduate Class (derived)                              +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
class Undergraduate : public Student
{
private: 
  /* variables */
  int year;

public:
  /* Print function */
  virtual void print(long s, char *n, int m, double u, int g);
  
  /* Undergraduate Constructor */
  Undergraduate(long,char *,int,double,int,int);
//  int get_year();
};

#endif

