/* ++[   MP6 - collection.h  ]+++++++++++++++++++++++++++++++++++
   +                                                            +
   + Zaczek, Mariusz                                            +
   + CS 223 - Monday 11:00am - 1:00 pm                          +
   + 4/29/98                                                    +
   +                                                            +   
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

#ifndef COLLECTION_H
#define COLLECTION_H

#include "collection.h"
//#include "student.h"  

/* ++[ Class - cCollection (TEMPLATIZED) ]+++++++++++++++++++++++
   +                                                            +
   + cCollection Class                                          +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

template<class T> class cCollection
{
  /* Prints out the students on separate lines */
  friend ostream &operator<<(ostream &out, const cCollection<T>& col);

private:
  /* The number of elements in the array */ 
  int logical_length;  

  /* The size of the array */
  int physical_length;

  /* Pointer to the first element in the array */
  T *data;

public:
  /* Constructor */  
  cCollection(int initialLength = 0, int allocLengthHint = 0);

  /* Copy Constructor */
  cCollection(const cCollection<T> &source);

  /* Destructor */
  ~cCollection();

  /* Overloaded assignment operator, make deep copies */
  cCollection<T> &operator=(const cCollection<T> &source);

  /* Returns the logical length of the array (accessor) */
  int Length(void) const;

  /* Resize the array if no more space available */
  void Resize(int newLength);  

  /* Adds element to the end of the array */
  void AddElem(const T &elem);
  
  /* Overloaded [] operator to return the element in the array */
  T &operator[] (int elemNum);
  
  /* Overloaded [] operator to return the element in the array */
  const T &operator[] (int elemNum) const;
};

#endif
