/* ++[ Machine Problem #3 ]++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + Zaczek, Mariusz                                            +
   + CS 223 - Monday 11:00am - 1:00 pm                          +
   + 3/7/98                                                     +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

/* Include declarations */
#include <iostream.h>
#include <string.h>
#include <ctype.h>
#include "sarr.h"

/* Declare the sort function from sort.C */
void sort(char *A[], int first, int last, int method);

/* ++[  A  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + void StringArray::StringArray()                            +
   +                                                            +
   +  - Acts as the constructor.                                +
   +  - Initializes counter of # of strings			+   
   +								+
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

StringArray::StringArray()
{
  counter=0;
}

/* ++[  B  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + void StringArray::insert(char s[])                         +
   +                                                            +
   +  Receives: char s[] - a string				+
   +								+
   +  - dynamically allocates memory for new string and then    +
   +    copies the string into the array			+ 
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

void StringArray::insert(char s[])
{
  if (counter >= 199)
    return;
    
  array[counter]=new char[strlen(s)+1];
  strcpy(array[counter],s);
  counter++;
  return;
}
 
/* ++[  C  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + void StringArray::print()                                  +
   +                                                            +
   +  - Prints out the array in current order.			+
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

void StringArray::print()
{
  for(int i=0;i<counter;i++)
    cout << array[i] << " ";
    
  cout << endl;
}

/* ++[  D  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + void StringArray::sortAscending()                          +
   +                                                            +
   +  - Calls sort function to sort current array in ascending  +
   +    order. It then calls the print() function to print the  +
   +    new sorted array.					+
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

void StringArray::sortAscending()
{
  sort(array,0,counter-1,2);
  print(); 
}
 
/* ++[  E  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + void StringArray::sortDescending()                         +
   +                                                            +
   +  - Calls sort function to sort current array in descending +
   +    order. It then calls the print() function to print the  +
   +    new sorted array.                                       +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

void StringArray::sortDescending()
{
  sort(array,0,counter-1,3);
  print();
}
 
/* ++[  F  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + void StringArray::clearArray()                             +
   +                                                            +
   +  - Clear the array by setting each element to '\0'         +
   +  - Sets counter back to zero.				+
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

void StringArray::clearArray()
{
   for(int l=0;l<counter;l++)
   {    
     strcpy(array[l],"\0");
   }
   counter = 0;
}

/* ++[  G  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + void StringArray::clearArray()                             +
   +                                                            +
   +  - Clear the array by clearing the dynamically allocated   +
   +    strings.                                                +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
   
StringArray::~StringArray()
{
   for(int k=0;k<counter;k++)
   {  
     delete array[k];
   }
}   

