// **********************************************
// *                                            *
// *  main.C (MP 8)                             *
// *                                            *
// **********************************************

#include <iostream.h>
#include <stdlib.h>
#include <string.h>		//C library for string utilities
#include "string.h"
#include "nodedisjoint.h"
#include "stack.h"

main()
{
Stack<int> S;			//for testing the exceptions in stack
DisjointSets<int> SetSystem;	//collection of disjoint sets
				//    (info will always be ignored)
char tmp[80];			//since >> isn't defined for String class
String cmd;			//command from user
int arg1, arg2;			//numeric arguments from user
int val;			//return value from function calls

try			//test stack exception throwing for Pop
  {
  S.Pop();
  cerr << "Didn't throw exception in Pop" << endl;
  exit(1);
  }
catch(StackError err)
  {
  if(strcmp("Trying to remove top element of empty stack!", err.message) != 0)
    {
    cerr << "Incorrect error message in exception for Pop" << endl;
    exit(1);
    }
  }

try			//test stack exception throwing for Top
  {
  S.Top();
  cerr << "Didn't throw exception in Top" << endl;
  exit(1);
  }
catch(StackError err)
  {
  if(strcmp("Trying to read top element from empty stack!", err.message) != 0) 
    {
    cerr << "Incorrect error message in exception for Top" << endl;
    exit(1);
    }
  }

//now test functionality for disjoint set
while(cin >> tmp)		//get next command
  {
  cmd = tmp;
  if(cmd == "end")
    {
    cout << "End of program" << endl;
    exit(0);
    }
  else if(cmd == "makeset")
    {
    cin >> arg1;		//read the number to put in set
    SetSystem.MakeSet(arg1, 0);
    }
  else if(cmd == "union")
    {
    cin >> arg1 >> arg2;	//read the sets to join
    if(SetSystem.Union(arg1, arg2) == 0)
      cout << "Invalid Union: " << arg1 << ", " << arg2 << endl;
    }
  else if(cmd == "find")
    {
    cin >> arg1;		//read in the value to find
    val = SetSystem.Find(arg1);
    if(val == 0)
      cout << "key " << arg1 << " not found" << endl;
    else
      cout << arg1 << " is a member of set " << val << endl;
    }
  else if(cmd == "undo")
    {
    if(SetSystem.Undo())
      cout << "Undo successful" << endl;
    else
      cout << "Unable to undo" << endl;
    }
  else
    cout << "Unrecognized command: '" << cmd << "'" << endl;
  }
cout << "End of program" << endl;
}
