// *****************************************************
// *                                                   *
// *   word.C (MP6)                                    *   
// *                                                   *
// *   Implementaiton for a key/info class             * 
// *                                                   *
// *   Written 2 March 1999 by Jason Zych              * 
// *						       *
// *   Modified:  March 28 1999                        *
// *     Author:  Zaczek, Mariusz                      *
// *                                                   *
// *       - added: operator<<, operator>>             *
// *                                                   * 
// *****************************************************

#include <fstream.h>
#include "wordcounter.h"


// WordCounter
//    - default constructor
//    - initializes object to default values
WordCounter::WordCounter() : countContainer(), AVLContainer()
{
   // nothing to do here
} 


// InsertWord
//    - parameters : insWord - word to be inserted into tree
//    - inserts word into tree with a count of 1. If word is 
//       already in the tree, then simply increase the count
//       of the word. 
void WordCounter::InsertWord(String insWord)
{
   KeyPair<String, int> searchKey(insWord, 1); 

   if (countContainer.Find(searchKey))
   {
      KeyPair<String, int> tempKey(countContainer.Last());
      countContainer.Remove(tempKey); 
      KeyPair<String, int> newKey(tempKey.GetKey(), tempKey.GetInfo() + 1); 
      countContainer.Insert(newKey); 
   }
   else
   {
      countContainer.Insert(searchKey);  
   }

   if (AVLContainer.Find(searchKey))
   {
     KeyPair<String, int> tempKey_2(AVLContainer.Last());
     AVLContainer.Remove(tempKey_2);
     KeyPair<String, int> newKey_2(tempKey_2.GetKey(), tempKey_2.GetInfo() + 1);
     AVLContainer.Insert(newKey_2);
   }
   else
   {
     AVLContainer.Insert(searchKey);
   }

} 


// PrintFullInfo
//    - prints the words in tree in alphabetical order,
//        and along with the words, prints their counts.
void WordCounter::PrintFullInfo() const
{
   cout << "--- BST, in order:" << endl;
   countContainer.InOrder(); 

   cout << "--- AVL, in order:" << endl;
   AVLContainer.InOrder();

   cout <<   "BST comparisons so far: " << countContainer.ReturnTotal() 
        << "\nAVL comparisons so far: " << AVLContainer.ReturnTotal() << endl;
   
}


// PrintWordInfo
//    - parameters : searchWord - word whose info will be printed 
//    - print searchWord and its count  
void WordCounter::PrintWordInfo(String searchWord)
{
   KeyPair<String, int> searchKey(searchWord, 0); 
   AVLContainer.Find(searchKey);

   if (countContainer.Find(searchKey))
      cout << countContainer.Last() << endl;
   else
      cout << searchKey << endl;  
} 




// WriteToFile
//    - parameters : fileName - the name of the file to open and
//                           write to
//    - writes to the file indicated by the parameter. Will create
//                           file if no such file exists.
void WordCounter::WriteToFile(char* fileOut)
{
   BSTree<KeyPair<String, int> > count2(countContainer); 
   ofstream textfile(fileOut);
   if (!fileOut)
      cout << "Error initializing file in WriteToFile." << endl; 
   else
   { 
      KeyPair<String, int> temp; 
      while (!count2.IsEmpty())
      {
         count2.Find_Min(); 
         temp = count2.Last(); 
         textfile << temp.GetKey() << " " << temp.GetInfo() << endl; 
         count2.Remove(temp); 
      }
   }
   textfile.close(); 
}



// ReadFrom File
//    - parameters : fileName - the name of the file to open and
//                             read from
//    - reads from the file indicated by the parameter
void WordCounter::ReadFromFile(char* fileIn)
{
   char* theString = new char[100]; 
   int count; 
   KeyPair<String, int> temp; 
   ifstream newfile(fileIn); 

   if (!newfile)
   { 
      cout << "Error initializing file in ReadToFile." << endl; 
   }
   else
   {
      while (newfile >> theString >> count)
      { 
         temp = KeyPair<String, int>(theString, count); 
         countContainer.Insert(temp); 
      }
   }
   newfile.close(); 
   delete theString; 
}


// operator<<
//    - parameters : Out - an ostream reference
//                 : outputWord - a WordCounter to write to output 
//    - return value : an ostream reference
//    - writes the given WordCounter to the given output stream
//       ...this includes writing the BS and AVL trees
ostream& operator<<(ostream& Out, const WordCounter& outputWord)
{
  Out << outputWord.countContainer 
      << "2 Key: **********dummyKeyPair**********    Info: 0\n" 
      << outputWord.AVLContainer << endl;
  
  return Out;
}


// operator>>
//    - parameters : In - an istream reference
//                 : inputWord - a WordCounter to read from input
//    - return value : an istream reference
//    - reads the given WordCounter from the given input stream 
//       ... this includes reading the BS and AVL trees
istream& operator>>(istream& In, WordCounter& inputWord)
{
  In >> inputWord.countContainer;
  In >> inputWord.AVLContainer;

  return In;
}

