// *****************************************************
// *                                                   *
// *   word.h (MP5)                                    *   
// *                                                   *
// *   Interface for a key/info class                  * 
// *                                                   *
// *   Written 2 March 1999 by Jason Zych              * 
// *                                                   * 
// *****************************************************

#include <fstream.h>
#include "keypair.h"
#include "string.h"
#include "bstree.h"

class WordCounter
{
public:

   // WordCounter
   //    - default constructor
   //    - initializes object to default values
   WordCounter(); 


   // InsertWord
   //    - parameters : insWord - word to be inserted into tree
   //    - inserts word into tree with a count of 1. If word is 
   //       already in the tree, then simply increase the count
   //       of the word. 
   void InsertWord(String insWord); 


   // PrintFullInfo
   //    - prints the words in tree in alphabetical order,
   //        and along with the words, prints their counts.
   void PrintFullInfo() const;


   // PrintWordInfo
   //    - parameters : searchWord - word whose info will be printed 
   //    - print searchWord and its count  
   void PrintWordInfo(String searchWord);


   // WriteToFile
   //    - parameters : fileName - the name of the file to open and
   // 				write to
   //    - writes to the file indicated by the parameter. Will create
   // 				file if no such file exists.
   void WriteToFile(char* fileName);


   // ReadFrom File
   //    - parameters : fileName - the name of the file to open and
   //                             read from
   //    - reads from the file indicated by the parameter 
   void ReadFromFile(char* fileName); 


private:

   BSTree<KeyPair<String, int> > countContainer;  // tree to hold keypair
					          //   objects for fast
						  //   lookup
  
};

   


