// ******************************************************
// *                                                    *
// *  main.C (MP5)                                      *
// *                                                    *
// *  Driver file for testing MP5 functions             *
// *                                                    *
// *  Written 2 March 1999 by Jason Zych                *
// *                                                    *
// ******************************************************

#include <iostream.h>
#include <fstream.h>
#include "string.h"
#include "wordcounter.h"


int main(int argc, char* argv[])
{
   // argc is the number of words on the command line that
   //   started this program
   // argv[] is the array of C++ strings containing those
   //    words
   // so, argv[0] is "a.out".
   // if we invoke our program with 
   //  		a.out test.1
   //  then argv[1] is "test.1"

   char* newString = new char[100]; // string to read into
   String s1;
   WordCounter w1, w2;

   // create an object of type ifstream
   // call it "textfile"
   // argv[1] is the parameter passed to the constructor
   // this will open an input stream object for the file named the 
   //   string in argv[1], and this object will be called "textfile".
   ifstream textfile(argv[1]);  

   if (!textfile)              // textfile didn't open properly
      cout << "file error!" << endl; 
   else                        // textfile DID open properly
   {
      while (textfile >> newString)  // as long as the read-in works 
      {
         s1 = String(newString);   // cast char* to String
         w1.InsertWord(s1);  
      }
   }
   delete newString;   // clean up the memory we used
   textfile.close();   // when we are done with filestream, close it

   cout << "*** Individual word checks:" << endl; 
   w1.PrintWordInfo(String("Does"));   
   w1.PrintWordInfo("25"); 
   w1.PrintWordInfo("Sisyphus"); 
   w1.PrintWordInfo("I"); 
   cout << endl;  

   cout << "*** Results in full tree:" << endl; 
   w1.PrintFullInfo(); 
   cout << endl; 
 
   // This call will write the object w1 to a file called "filetest"
   w1.WriteToFile("filetest"); 

   // w2 is empty right now. This call will read the contents of
   //  "filetest" into w2, so w2 will now hold the same data as w1. 
   w2.ReadFromFile("filetest"); 

   cout << "*** Results in tree read from file: " << endl; 
   w2.PrintFullInfo(); 
   cout << endl; 

   return 0; 
}


