// *****************************************************
// *                                                   *
// *   keypair.h (MP5)                                 *   
// *                                                   *
// *   Interface for a key/info class                  * 
// *                                                   *
// *   Written 2 March 1999 by Jason Zych              * 
// *    Altered 6 March 1999 -- ifndef/endif added     *
// *                                                   * 
// *****************************************************

#ifndef _KEYPAIR_H
#define _KEYPAIR_H

#include <iostream.h>

template <class Ktype, class Etype>
class KeyPair
{
public:

   // KeyPair 
   //    - default constructor
   //    - initializes object to default values
   KeyPair(); 


   // KeyPair
   //    - constructor
   //    - parameters : initKey - initial key
   //                 : initInfo - initial information 
   //    - initializes object to parameter values
   KeyPair(Ktype initKey, Etype initInfo);


   // GetKey
   //    - return type : generic type of key
   //    - returns value of key
   Ktype GetKey() const;


   // GetInfo
   //    - return type : generic info type
   //    - returns value of information field
   Etype GetInfo() const; 


   // operator==
   //    - parameters : comparePair - a KeyPair object to compare to this one
   //    - return value : a boolean-valued integer
   //    - returns 1 if the KeyPairs are equal, with two KeyPair objects 
   //          being considered equal if they have equal keys. Returns 
   //          0 otherwise
   int operator==(const KeyPair& comparePair) const;


   // operator!=
   //    - parameters : comparePair - a KeyPair object to compare to this one
   //    - return value : a boolean-valued integer
   //    - returns 1 if the KeyPairs are not equal, with two KeyPair objects 
   //          being considered *equal* if they have equal keys. Returns 
   //          1 otherwise
   int operator!=(const KeyPair& comparePair) const;

 

   // operator< 
   //    - parameters : comparePair - a KeyPair object to compare to this one
   //    - return value : a boolean-valued integer
   //    - returns 1 if the key of this KeyPair object comes before the key 
   //         of the parameter KeyPair object in whatever ordering is 
   //         appropriate for the key type of the KeyPair objects; returns 
   //         0 otherwise
   int operator<(const KeyPair& comparePair) const;



   // operator>
   //    - parameters : comparePair - a KeyPair object to compare to this one
   //    - return value : a boolean-valued integer
   //    - returns 1 if the key of this KeyPair object comes after the key 
   //         of the parameter KeyPair object in whatever ordering is 
   //         appropriate for the key type of the KeyPair objects; returns 
   //         0 otherwise
   int operator>(const KeyPair& comparePair) const;


   // operator<< 
   //    - parameters : Out - an ostream reference 
   //                 : outputString - a KeyPair to write to output 
   //    - return value : an ostream reference
   //    - writes the given String to the given output stream 
   friend ostream & operator<<(ostream & Out, 
			const KeyPair<Ktype, Etype>& outputPair);
   
private:

   Ktype key;        // internal key field of pair
   Etype info;       // internal information field of pair

};



// These lines necessary to allow CC to understand the template 
//   friend function operator<<
template <class Ktype, class Etype>
ostream& operator<<(ostream& Out, const KeyPair<Ktype, Etype>&);



#endif



