// ******************************************************
// *                                                    *
// *  listfns.C (MP4)                                   *
// *                                                    *
// *  Global list functions for MP4                     * 
// *                                                    *
// *  Written 20 February 1999 by Jason Zych            *
// *                                                    *
// ******************************************************

#include "listfns.h"


// Replace
//    - parameters : repList - the list to run the replacement on 
//                 : oldVal - the value we want to replace in the list
//                 : newVal - the value we want to replace it with
//    - replaces all occurences of oldVal in the list with newVal, 
//        and then sets current to be the first item in the list,
//        if there are items in the list   
template <class Etype>
void Replace(List<Etype>& repList, const Etype oldVal, const Etype newVal)
{
   repList.Head();
   for (int i = 1; i<=repList.Length(); i++)
   {
      if (repList.Retrieve() == oldVal)
         repList.Update(newVal); 
      repList++; 
   }
   repList.Head(); 
}



  
// ToArray
//    - parameters : readList - a list to write into an Array
//    - return type : an Array object whose size is equal to the size
//                       of the list
//    - returns an Array containing the elements of the list, 
//        appearing in the same order in the Array as they do in the list
template <class Etype>
Array<Etype> ToArray(List<Etype>& readList)
{

   readList.Head(); 
   Array<Etype> newArr(1, readList.Length()); 
   int index = 1;
   for (int i = 1; i<=readList.Length(); i++)
   {
      newArr[index] = readList.Retrieve(); 
      index++; 
      readList++; 
   }
   replist.Head(); 
   return newArr; 
}





// SortedInsert
//    - parameters : insList - the list to insert into
//                 : insElem - the value we wish to insert  
//    - inserts the parameter element in sorted order. This 
//        function requires that operator< is defined for the 
//        type in question, and assumes that the list is already
//        sorted from smallest to largest value as defined by
//        operator< on that type. The newly-inserted element
//        should become the current element. 
template <class Etype>
void SortedInsert(List<Etype>& insList, const Etype X) 
{
   insList.Head(); 
   int len = insList.Length(); 
   int count = 1; 
   if (len != 0)   // list has elements
   {
      while ((insList.Retrieve() <= X) && (count <= len))
      {
         insList++; 
         count++;
      }  
      if (count == len+1)
         insList.InsertAfter(X); 
      else
         insList.InsertBefore(X); 
   }
   else   // list is empty
      insList.InsertBefore(X); 
}




// Reverse 
//    - parameters : revList - the list to reverse
//    - reverses the order of the elements in the list
template <class Etype>
void Reverse(List<Etype>& revList)
{
   List<Etype> tempList; 
   revList.Head(); 
   for (int i = 1; i<=revList.Length(); i++)
   {
      tempList.InsertBefore(revList.Retrieve()); 
      revList++; 
   }
   revList = tempList; 
}




// Splice
//    - parameters : baseList - the list to be spliced into 
//                 : spliceList - a list to be spliced into the base list
//    - splices the values of spliceList into baselist starting at the 
//        position after the current value of baselist. When the
//        function has completed, the current location indicator of 
//        baselist should be set to be the first element of baselist, 
//        if any  elements are in baselist. The parameter list spliceList  
//        should be empty when you are done, as you are not splicing
//        copies of the values of spliceList, but rather, you are
//        splicing the values themselves. 
template <class Etype>
void Splice(List<Etype>& baseList, List<Etype>& spliceList) 
{
   spliceList.Head();  
   for (int i = 1; i<=spliceList.Length(); i++)
   {  
      baseList.InsertAfter(spliceList.Retrieve()); 
      spliceList++; 
   }
   spliceList.Clear(); 
   baseList.Head(); 
}







