// ******************************************************
// *                                                    *
// *  main.C (MP4)                                      *
// *                                                    *
// *  Driver file for testing MP4 functions             *
// *                                                    *
// *  Written 20 February 1999 by Jason Zych            *
// *                                                    *
// ******************************************************

#include <iostream.h>
#include "singlist.h"
#include "array.h"
#include "listfns.h"


int main()
{
   int i;
   cout << "******************************************" << endl; 
   cout << "*********** Begin part 1: member functions" << endl; 
   cout << endl << endl;

   // ************ Testing SortedInsert

   List<int> l1; 
   l1.SortedInsert(5); 
   l1.Print(); 
   cout << endl; 
   l1.SortedInsert(2); 
   l1.Print(); 
   cout << endl; 
   l1.SortedInsert(3); 
   l1.Print(); 
   cout << endl; 
   l1.SortedInsert(6); 
   l1.Print(); 
   cout << endl; 
   l1.SortedInsert(1); 
   l1.Print();
   cout << endl; 
   l1.SortedInsert(4); 
   cout << "*** Here is the final list after inserts:" << endl;  
   l1.Print(); 
   cout << endl << endl; 


   // ************ Testing Reverse

   List<int> l2(l1); 
   l1.Reverse(); 
   cout << "*** Here is that list, reversed:" << endl;  
   l1.Print(); 
   cout << endl; 
   List<int> l3; 
   l3.Reverse(); 
   cout << "*** Here is another list, reversed:" << endl; 
   l3.Print(); 
   cout << endl << endl; 


   // ************ Testing Splice

   l1.Head(); 
   l1++; 
   l1++; 
   cout << "*** Here is the base list:" << endl; 
   l1.Print(); 
   cout << endl;  
   cout << "*** Here is the list to be spliced:" << endl; 
   l2.Print(); 
   cout << endl; 
   l1.Splice(l2); 
   cout << "*** Here is the base list, post-splice:" << endl; 
   l1.Print(); 
   cout << endl; 
   cout << "*** Here is the splice list, post-splice:" << endl; 
   l2.Print(); 
   cout << endl;    
   cout << "---------------" << endl; 
   cout << "*** Another splice attempt with the same two lists:" << endl; 
   l1.Splice(l2);   
   cout << "*** Base list:" << endl; 
   l1.Print();
   cout << endl; 
   cout << "*** Splice list:" << endl; 
   l2.Print(); 
   cout << endl; 
   cout << "---------------" << endl; 
   cout << "*** Final splice attempt, with empty list and large list:" << endl;
   l3.Splice(l1); 
   cout << "*** Result of splicing large list into empty list:" << endl; 
   l3.Print(); 
   cout << endl; 
   cout << "*** Former large list:" << endl; 
   l1.Print(); 
   cout << endl << endl; 

   // **************** Testing Replace
   cout << "*** Our current list:" << endl; 
   l3.Print(); 
   cout << endl; 
   cout << "*** Replace 2 with 7:" << endl;  
   l3.Replace(2, 7);
   l3.Print(); 
   cout << endl << endl;  

   // *************** Testing ToArray 

   cout << "*** Our current list:" << endl;
   l3.Print();
   cout << endl; 
   cout << "*** Write to an array:" << endl;  
   Array<int> a1 = l3.ToArray(); 
   cout << "*** Printout of array:" << endl; 
   for (i = a1.Lower(); i<=a1.Upper(); i++)
      cout << a1[i] << " "; 
   cout << endl << endl << endl;  



   cout << "******************************************" << endl; 
   cout << "*********** Begin part 2: global functions" << endl; 
   cout << endl << endl;



   // ************ Testing SortedInsert

   List<int> gl1;
   SortedInsert(gl1, 5);
   gl1.Print();
   cout << endl;
   SortedInsert(gl1, 2);
   gl1.Print();
   cout << endl;
   SortedInsert(gl1, 3);
   gl1.Print();
   cout << endl;
   SortedInsert(gl1, 6);
   gl1.Print();
   cout << endl;
   SortedInsert(gl1, 1);
   gl1.Print();
   cout << endl;
   SortedInsert(gl1, 4);
   cout << "*** Here is the final list after inserts:" << endl;
   gl1.Print();
   cout << endl << endl;


   // ************ Testing Reverse

  List<int> gl2(gl1);
   Reverse(gl1);
   cout << "*** Here is that list, reversed:" << endl;
   gl1.Print();
   cout << endl;
   List<int> gl3;
   Reverse(gl3);
   cout << "*** Here is another list, reversed:" << endl;
   gl3.Print();
   cout << endl << endl;


   // ************ Testing Splice

   gl1.Head();
   gl1++;
   gl1++;
   cout << "*** Here is the base list:" << endl;
   gl1.Print();
   cout << endl;
   cout << "*** Here is the list to be spliced:" << endl;
   gl2.Print();
   cout << endl;
   Splice(gl1, gl2);
   cout << "*** Here is the base list, post-splice:" << endl;
   gl1.Print();
   cout << endl;
   cout << "*** Here is the splice list, post-splice:" << endl;
   gl2.Print();
   cout << endl;
   cout << "---------------" << endl;
   cout << "*** Another splice attempt with the same two lists:" << endl;
   Splice(gl1, gl2);
   cout << "*** Base list:" << endl;
   gl1.Print();
   cout << endl;
   cout << "*** Splice list:" << endl;
   gl2.Print();
   cout << endl;
   cout << "---------------" << endl;
   cout << "*** Final splice attempt, with empty list and large list:" << endl;
   Splice(gl3, gl1);
   cout << "*** Result of splicing large list into empty list:" << endl;
   gl3.Print();
   cout << endl;
   cout << "*** Former large list:" << endl;
   gl1.Print();
   cout << endl << endl;


/*
 List<int> gl3;

 gl3.InsertAfter(5);
 gl3.InsertAfter(2);
 gl3.InsertAfter(6);
 gl3.InsertAfter(1);
 gl3.InsertAfter(2);
 gl3.InsertBefore(22);
*/

   // **************** Testing Replace

   cout << "*** Our current list:" << endl;
   gl3.Print();
   cout << endl;
   cout << "*** Replace 2 with 7:" << endl;
   Replace(gl3, 2, 7);
   gl3.Print();
   cout << endl << endl;


   // *************** Testing ToArray

   cout << "*** Our current list:" << endl;
   gl3.Print();
   cout << endl;
   cout << "*** Write to an array:" << endl;
   Array<int> ga1 = gl3.ToArray();
   cout << "*** Printout of array:" << endl;
   for (i = ga1.Lower(); i<=ga1.Upper(); i++)
      cout << ga1[i] << " ";
   cout << endl << endl << endl;


   return 0; 
}

