// ******************************************************
// *                                                    *
// *  testfns.h (MP3                                    *
// *                                                    *
// *  Driver file for testing MP3 classes               *
// *                                                    *
// *  Written 14 February 1999 by Jason Zych            *
// *                                                    *
// ******************************************************

#ifndef _MP2_TESTFNS_H
#define _MP2_TESTFNS_H

#include "simsys.h"

// CreateObjectsInSystem
//    - parameters : sys - a reference to the System object
//                      declared in main.C
//    - first part of testing; here is where we create our
//        objects and this is where new code we add gets
//        used 
void CreateObjectsInSystem(System& sys); 


// UseSystem
//    - parameters : sys - a reference to the System object
//                      declared in main.C
//    - second part of testing; this code can be called
//        before or after adding new objects to the
//        system, and will work *without any changes*
//        even though it was written and compiles and
//        runs before you add your two types to the
//        system. 
void UseSystem(System& sys); 

#endif

