// *************************************************
// *                                               *
// *  panel.C (MP3)                                *
// *                                               *
// *  Inplementation for a panel class             * 
// *                                               *
// *  Written 13 February 1999 by Jason Zych       *
// *                                               *
// *************************************************


#include <iostream.h>
#include "panel.h"


// Panel
//    - default constructor
//    - initializes object to have default values
Panel::Panel() : Container()
{
   // Technically, nothing needed here. 
} 



// Panel
//    - constructor
//    - parameters : initLL - the initializing lower left point
//                                of parent window
//                 : initUR - the initializing upper right point
//                                of parent window 
//    - initializes object to parameter values 
Panel::Panel(Point initLL, Point initUR) : Container()
{
   parentLowerLeft = initLL; 
   parentUpperRight = initUR; 
} 


// ParentResized
//    - parameters : setLL - the new lower left point of parent window
//                 : setUR - the new upper right point of parent window
//    - assigns the stored parent boundary coords to parameter values
void Panel::ParentResized(Point setLL, Point setUR)
{
   parentLowerLeft = setLL; 
   parentUpperRight = setUR; 
}



// Draw
//    - "draws" this object to the screen (just a text-based description)
void Panel::Draw()
{
   cout << "This panel is held by an application window" << endl; 
   cout << "  with the following corner points:" << endl; 

   cout << "(" << parentLowerLeft.XCoord() << ", ";
   cout << parentLowerLeft.YCoord() << "), (" << parentUpperRight.XCoord();
   cout << ", " << parentUpperRight.YCoord() << ")" << endl; 

   cout << "This panel holds the following components:" << endl; 
   DrawHelper();   
}


// Clone
//    - return value : a Panel pointer
//    - returns a pointer to a new object of this type
Component* Panel::Clone() 
{
   return new Panel(*this); 
}

