// *************************************************
// *                                               *
// *  easel.C (MP3)                                *
// *                                               *
// *  Implementaiton for an easel class            *
// *                                               *
// *  Written 13 February 1999 by Jason Zych       *
// *                                               *
// *************************************************

#include <iostream.h>
#include "easel.h"


// Easel
//    - default constructor
//    - initializes object to have default values
Easel::Easel() : Component()
{
   ptArray.SetBounds(1, 20);
   lastPtUsed = 0;
} 


// Draw
//    - "draws" this object to the screen (just a text-based description)
void Easel::Draw()
{
   cout << "This easel contains the following points:" << endl; 
   for (int i = ptArray.Lower(); i<=lastPtUsed; i++)
   {
      cout << "(" << ptArray[i].XCoord() << ", ";
      cout << ptArray[i].YCoord() << ")" << endl;
   } 
}


// Clone
//    - return value : a Easel pointer
//    - returns a pointer to a new object of this type
Component* Easel::Clone()
{
   return new Easel(*this); 
} 


// HandleMouseClick
//    - parameters : locationPoint - location of mouse click
//    - processes the "mouse click" event. If mouse click is on
//        an object that does not support any mouse-click-activated
//        operations, then nothing will happen.
void Easel::HandleMouseClick(Point locationPoint)
{
   if (Contains(locationPoint))
   {
      if (lastPtUsed == ptArray.Upper())
      {
         // double size of array; (lower + 2*size - 1) is new upper
         ptArray.SetBounds(ptArray.Lower(), 
                            ptArray.Lower() + 2*ptArray.Size() - 1);
      }
      lastPtUsed++;
      ptArray[lastPtUsed] = locationPoint; 
   }
}

