// *************************************************
// *                                               *
// *  point.h (MP3     )                           *
// *                                               *
// *  Interface for a point class                  *
// *                                               *
// *  Written 13 February 1999 by Jason Zych       *
// *                                               *
// *************************************************


#ifndef _POINT_H
#define _POINT_H

class Point
{
public:

   // Point
   //    - default constructor
   //    - initializes object to have default values
   Point(); 


   // Point
   //    - constructor
   //    - parameters : xLoc - the x-coord of the location
   //                 : yLoc - the y-coord of the location
   //    - initializes object to parameter values
   Point(int xLoc, int yLoc);


   // XCoord
   //    - return value : integer coordinate value
   //    - returns x-coord of current location
   int XCoord(); 


   // YCoord
   //    - return value : integer coordinate value
   //    - returns y-coord of current location
   int YCoord(); 


  
   // SetCoordinates
   //    - parameters : xLoc - the x-coord of the new location 
   //                 : yLoc - the y-coord of the new location
   //    - sets location equal to the parameter location
   void SetCoordinates(int xLoc, int yLoc);


private:

   int xCoord; 
   int yCoord; 

};

#endif

   

