// *************************************************
// *                                               *
// *  panel.C (MP3)                                *
// *                                               * 
// *  Implementation for a panel class             *
// *                                               *
// *  Author: Mariusz Zaczek                       *
// *  Date:   February 17, 1999                    *
// *  Class:  Tu 11-1 Chad Piper                   *
// *************************************************

#include <iostream.h>
#include "panel.h"


// Panel
//    - default constructor
//    - does nothing for this class since Point class
//      intializes the points.
Panel::Panel()
{ } 


// Panel
//    - constructor
//    - parameters : One - 1st corner point of the panel
//                   Two - 2nd corner point of the panel
//    - initializes points to parameter values
Panel::Panel(Point One, Point Two)
{
  FirstObject = One;
  SecondObject = Two;
} 


// ParentResized
//    - parameters : One - 1st corner point of the panel
//                   Two - 2nd corner point of the panel
void Panel::ParentResized(Point One, Point Two)
{
  FirstObject = One;
  SecondObject = Two;
}


// Draw
//    - "draws" this object to the screen (just a text-based description)
void Panel::Draw() 
{
   cout << "This panel is held by an application window\n" 
        << "  with the following corner points:"<< endl; 

   cout << "(" << FirstObject.XCoord() << ", " << FirstObject.YCoord() << "), ("
               << SecondObject.XCoord() << ", " << SecondObject.YCoord() << ")" << endl;
        
   cout << "This panel holds the following components:" << endl;
   
   DrawHelper(); 
}


// Clone
//    - return value : a Panel pointer
//    - returns a pointer to a new object of this type
Component* Panel::Clone()
{
   return new Panel(*this);
}




