// *************************************************
// *                                               *
// *  easel.h (MP3)                                *
// *                                               *
// *  Interface for a easel class                  *
// *                                               *
// *  Author: Mariusz Zaczek                       *
// *  Date:   February 17, 1999                    *
// *  Class:  Tu 11-1 Chad Piper                   *
// *************************************************

#ifndef _EASEL_H
#define _EASEL_H

#include "component.h"
#include "point.h"
#include "array.h"

class Easel : public Component
{
  private:
    Array<Point> pointArray;  // Array of points
    int numPoints;            // # of points clicked in panel

  public:

    // Easel
    //    - default constructor
    //    - initializes object to have default values
    Easel(); 

    // HandleMouseClick
    //    - parameters : locationPoint - location of mouse click
    //    - processes the "mouse click" event. If mouse click is on
    //        an object that does not support any mouse-click-activate
    //        operations, then nothing will happen.
    virtual void HandleMouseClick(Point locationPoint);


    // Draw
    //    - "draws" this object to the screen (just a text-based description)
    virtual void Draw();


    // Clone
    //    - return value : a easel pointer
    //    - returns a pointer to a new object of this type
    virtual Component* Clone(); 

};

#endif

   

