// *************************************************
// *                                               *
// *  component.h (MP3)                            *
// *                                               *
// *  Interface for an abstract component class    * 
// *                                               *
// *  Written 13 February 1999 by Jason Zych       *
// *    Revised 1:45pm 14 February; added destr.   *
// *                                               *
// *************************************************


#ifndef _COMPONENT_H
#define _COMPONENT_H

#include "point.h"

class Component
{
public:

   // Component
   //    - default constructor
   //    - initializes object to have default values
   Component(); 


   // *** CHANGED CODE  
   // ~Component
   //    - destructor
   //    - deallocates dynamically allocated memory
   //    - no dynamic memory in this object, but a virtual
   //        destructor makes run-time destruction of derived
   //        objects possible since the system can call the
   //        appropriate destructor off a Component* instead
   //        of being forced to call this one. 
   virtual ~Component() {} 


   // GetLocation
   //    - return value : location point
   //    - returns point that is lower left hand corner of object 
   Point GetLocation();


   // Contains
   //    - parameters : locationPoint - a point possibly in component
   //    - return value : integer holding boolean value
   //    - returns 1 if location point is within bounds of component,
   //         otherwise returns 0 
   int Contains(Point locationPoint); 


   // Contains
   //    - parameters : xLoc - x-location of point
   //                 : yLoc - y-location of point 
   //    - return value : integer holding boolean value
   //    - returns 1 if location point is within bounds of component,
   //         otherwise returns 0
   int Contains(int xLoc, int yLoc);



   // SetSize
   //    - parameters : width - the width (x-range) this object should have
   //                 : height - the height (y-range) this object should have
   //    - sets interior data so that the appropriate width and height
   //        are represented
   virtual void SetSize(int width, int height);



   // SetLocation
   //    - parameters : xLoc - x-location of new point
   //                 : yLoc - y-location of new point
   //    - sets interior data so that lower-left-hand corner of component
   //        is at parameter location 
   virtual void SetLocation(int xLoc, int yLoc); 



   // Draw
   //    - "draws" this object to the screen (just a text-based description)
   virtual void Draw() = 0; 


 
   // Clone
   //    - return value : a Component pointer
   //    - returns a pointer to a new object of this type
   virtual Component* Clone() = 0;
 
   

   // HandleMouseClick
   //    - parameters : locationPoint - location of mouse click
   //    - processes the "mouse click" event. If mouse click is on
   //        an object that does not support any mouse-click-activated
   //        operations, then nothing will happen.  
   virtual void HandleMouseClick(Point locationPoint) = 0;


protected:

   int lowerLeftX;
   int lowerLeftY;
   int upperRightX;
   int upperRightY;
};

#endif

   

