// *************************************************
// *                                               *
// *  component.C (MP3)                            *
// *                                               *
// *  Implementation for concrete functions of     *
// *      an abstract component class              * 
// *                                               *
// *  Written 13 February 1999 by Jason Zych       *
// *                                               *
// *************************************************


#include "component.h"



// Component
//    - default constructor
//    - initializes object to have default values
Component::Component()
{
   lowerLeftX = lowerLeftY = 0; 
   upperRightX = upperRightY = 0;
}



// GetLocation
//    - return value : location point
//    - returns point that is lower left hand corner of object 
Point Component::GetLocation()
{
   return Point(lowerLeftX, lowerLeftY);
}


// Contains
//    - parameters : locationPoint - a point possibly in component
//    - return value : integer holding boolean value
//    - returns 1 if location point is within bounds of component,
//         otherwise returns 0 
int Component::Contains(Point locationPoint)
{
   if (((locationPoint.XCoord() >= lowerLeftX) &&
        (locationPoint.XCoord() <= upperRightX)) 
                    &&
       ((locationPoint.YCoord() >= lowerLeftY) && 
        (locationPoint.YCoord() <= upperRightY)))
      return 1;
   else
      return 0;
} 



// Contains
//    - parameters : xLoc - x-location of point
//                 : yLoc - y-location of point 
//    - return value : integer holding boolean value
//    - returns 1 if location point is within bounds of component,
//         otherwise returns 0
int Component::Contains(int xLoc, int yLoc)
{
   if (((xLoc >= lowerLeftX) && (xLoc <= upperRightX)) 
                    &&
       ((yLoc  >= lowerLeftY) && (yLoc <= upperRightY)))
      return 1;
   else
      return 0;
}



// SetSize
//    - parameters : width - the width (x-range) this object should have
//                 : height - the height (y-range) this object should have
//    - sets interior data so that the appropriate width and height
//        are represented
void Component::SetSize(int width, int height)
{
   upperRightX = lowerLeftX + width;
   upperRightY = lowerLeftY + height; 
}



// SetLocation
//    - parameters : xLoc - x-location of new point
//                 : yLoc - y-location of new point
//    - sets interior data so that lower-left-hand corner of component
//        is at parameter location 
void Component::SetLocation(int xLoc, int yLoc) 
{
   int width = upperRightX - lowerLeftX;
   int height = upperRightY - lowerLeftY;
   
   lowerLeftX = xLoc;
   lowerLeftY = yLoc;
   upperRightX = lowerLeftX + width;
   upperRightY = lowerLeftY + height;
}

