// *************************************************
// *                                               *
// *  button.h (MP3)                               *
// *                                               *
// *  Interface for a button class                 *
// *                                               *
// *  Written 13 February 1999 by Jason Zych       *
// *                                               *
// *************************************************


#ifndef _BUTTON_H
#define _BUTTON_H

#include "component.h"
#include "string.h"
#include "point.h"

class Button : public Component
{
public:

   // Button
   //    - default constructor
   //    - initializes object to have default values
   Button(); 


   // Button
   //    - parameters : theName - name (label) for the button
   //    - initializes object with parameter value 
   Button(String theName);


   // GetName
   //    - return value : string name
   //    - returns name of button
   String GetName();


   // Draw
   //    - "draws" this object to the screen (just a text-based description)
   virtual void Draw();


   // Clone
   //    - return value : a Button pointer
   //    - returns a pointer to a new object of this type
   virtual Component* Clone(); 


   // HandleMouseClick
   //    - parameters : locationPoint - location of mouse click
   //    - processes the "mouse click" event. If mouse click is on
   //        an object that does not support any mouse-click-activated
   //        operations, then nothing will happen.
   virtual void HandleMouseClick(Point locationPoint);


private:

   String buttonName;

};

#endif

   

