// *************************************************
// *                                               *
// *  button.C (MP3)                               *
// *                                               *
// *  Implementation for a button class            *
// *                                               *
// *  Written 13 February 1999 by Jason Zych       *
// *                                               *
// *************************************************

#include <iostream.h>
#include "button.h"



// Button
//    - default constructor
//    - initializes object to have default values
Button::Button() : Component()
{
   // No code needed
} 


// Button
//    - parameters : theName - name (label) for the button
//    - initializes object with parameter value 
Button::Button(String theName) : Component()
{
   buttonName = theName;
}


// GetName
//    - return value : string name
//    - returns name of button
String Button::GetName()
{
   return buttonName;
}


// Draw
//    - "draws" this object to the screen (just a text-based description)
void Button::Draw()
{
   cout << "Now drawing button with name (";
   cout << buttonName << ")." <<  endl; 
}



// Clone
//    - return value : a Button pointer
//    - returns a pointer to a new object of this type
Component* Button::Clone()
{
   return new Button(*this);
} 



// HandleMouseClick
//    - parameters : locationPoint - location of mouse click
//    - processes the "mouse click" event. If mouse click is on
//        an object that does not support any mouse-click-activated
//        operations, then nothing will happen.
void Button::HandleMouseClick(Point locationPoint)
{
   if (Contains(locationPoint))
   {
      cout << "This button has been clicked on!" << endl; 
      if (buttonName.Length() > 0)
         cout << "The button has name (" << buttonName << ")" << endl;  
   }
}


