#include <stdlib.h>
#include <iostream.h>
#include "asserts.h"

// Assert will exit the program and print an error
//  message if the condition is not met. To be used
//  when proceeding would be fatal (divide by 0, for example). 
void Assert(int safeCondition, char* errMsg)
{
	if (!safeCondition)
	{
		cerr << "***Error: " << errMsg << endl;
		exit(1);
	}
}

// Warn will print an error message if the condition
//  is not met, but not exit. To be used when something
//  wrong has been requested, but denial of the request can
//  be graceful (later calculations do not depend on it). 
void Warn(int safeCondition, char* errMsg)
{
	if (!safeCondition)
		cerr << "***Warning: " << errMsg << endl;
}


