// ******************************************************
// *                                                    *
// *  named.h (MP2)                                     *
// *                                                    *
// *  Interface for a name and item class               * 
// *                                                    *
// *  Written 4 Feb 1999 by Jason Zych                  *
// *                                                    *
// ******************************************************

#ifndef _NAMED_H
#define _NAMED_H

#include "string.h"

template <class Etype>
class NamedItem
{
public:
 
   // NamedItem
   //    - default constructor
   //    - initializes object to default values   
   NamedItem();


   // NamedItem
   //    - constructor
   //    - parameters : first - C++ string holding the first name
   //                 : last - C++ string holding the last name
   //                 : item - an object of the generic type
   //    - initializes object to parameter values
   NamedItem(char* first, char* last, Etype item);


   // NamedItem
   //    - constructor
   //    - parameters : first - String object holding the first name
   //                 : last - String object holding the last name
   //                 : item - an object of the generic type
   //    - initializes object to parameter values
   NamedItem(String first, String last, Etype item); 


   // NamedItem
   //    - copy constructor
   //    - parameters : origVal - previously allocated NamedItem object
   //    - initializes object to be a copy of origVal
   NamedItem(const NamedItem& origVal);


   // ~NamedItem
   //    - destructor
   //    - deallocates dynamic memory
   ~NamedItem(); 


   // operator=
   //    - parameters : origVal - previously allocated NamedItem object
   //    - return value : a constant reference to this NamedItem object 
   //    - sets object to be a copy of origVal
   NamedItem& operator=(const NamedItem& origVal); 


   // GetFirstName
   //    - return value : a constant reference to a name string
   //    - returns first name 
   const String& GetFirstName() const; 


   // GetLastName
   //    - return value : a constant reference to a name string  
   //    - returns last name
   const String& GetLastName() const; 


   // GetItem
   //    - return value : a constant reference to a generic-type object
   //    - returns this object's internal item 
   const Etype& GetItem() const;

   
private:

   String* firstName;    // pointer to an object holding the first name
                         //   associated with this object
   String* lastName;     // pointer to an object holding the last name 
                         //   associated with this object
   Etype storedItem;     // the item of generic type that is being stored 
                         //   by this object

};

#endif

 

  
