// ******************************************************
// *                                                    *
// *  named.C (MP2)                                     *
// *                                                    *
// *  Implementation for a name and item class          * 
// *                                                    *
// *  Written 4 Feb 1999 by Jason Zych                  *
// *                                                    *
// ******************************************************

#include "named.h"



// NamedItem
//    - default constructor
//    - initializes object to default values
template <class Etype>
NamedItem<Etype>::NamedItem()
{
   firstName = new String();
   lastName = new String(); 
}



// NamedItem
//    - constructor
//    - parameters : first - C++ string holding the first name
//                 : last - C++ string holding the last name
//                 : item - an object of the generic type
//    - initializes object to parameter values
template <class Etype>
NamedItem<Etype>::NamedItem(char* first, char* last, Etype item)
{
   firstName = new String(first); 
   lastName = new String(last); 
   storedItem = item;
}



// NamedItem
//    - constructor
//    - parameters : first - String object holding the first name
//                 : last - String object holding the last name
//                 : item - an object of the generic type
//    - initializes object to parameter values
template <class Etype>
NamedItem<Etype>::NamedItem(String first, String last, Etype item)
{
   firstName = new String(first);
   lastName = new String(last);   
   storedItem = item;
} 



// NamedItem
//    - copy constructor
//    - parameters : origVal - previously allocated NamedItem object
//    - initializes object to be a copy of origVal
template <class Etype>
NamedItem<Etype>::NamedItem(const NamedItem<Etype>& origVal)
{
   firstName = new String(*(origVal.firstName)); 
   lastName = new String(*(origVal.lastName));
   storedItem = origVal.storedItem;
}



// ~NamedItem
//    - destructor
//    - deallocates dynamic memory
template <class Etype>
NamedItem<Etype>::~NamedItem()
{
   delete firstName;
   delete lastName;
}



// operator=
//    - parameters : origVal - previously allocated NamedItem object
//    - return value : a constant reference to this NamedItem object
//    - sets object to be a copy of origVal
template <class Etype>
NamedItem<Etype>& NamedItem<Etype>::operator=(const NamedItem<Etype>& origVal) 
{
   if (this!=&origVal)
   {
      delete firstName; 
      delete lastName; 
      firstName = new String(*(origVal.firstName)); 
      lastName = new String(*(origVal.lastName));
      storedItem = origVal.storedItem;
   }
   return *this;
}



// GetFirstName
//    - return value : a constant reference to a name string
//    - returns first name
template <class Etype>
const String& NamedItem<Etype>::GetFirstName() const 
{
   return *firstName;
}



// GetLastName
//    - return value : a constant reference to a name string
//    - returns last name
template <class Etype>
const String& NamedItem<Etype>::GetLastName() const 
{
   return *lastName;
}



// GetItem
//    - return value : a constant reference to generic-type object
//    - returns this object's internal item
template <class Etype>
const Etype& NamedItem<Etype>::GetItem() const
{
   return storedItem;
}



