/* +++++[  MP2 - NamedItem CLASS ]+++++++++++++++++++++++++++++++++++++++
   +                                                                    +
   +  Name:   Mariusz Zaczek                                            +
   +  Class:  Tu 11-1                                                   +
   +  Date:   2-6-1999                                                  +
   +                                                                    +
   +  This is the NamedItem class which is a template class that is     +
   +  used to assign names to objects in a collection of objects.       +
   +                                                                    +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

#include <iostream.h>
#include "string.h"
#include "named.h"

/* +++++[  NamedItem()  ]++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                                    +
   +   - parameters : none                                              +
   +                                                                    +
   +   - default constructor                                            +
   +   - initializes object to default values                           +
   +   - dynamically allocates FirstName and LastName                   +
   +                                                                    +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
template<class Etype>
NamedItem<Etype>::NamedItem()
{
  FirstName = new String;

  LastName = new String;
}

/* +++++[  NamedItem(char *First, char *Last, Etype object) ]++++++++++++
   +                                                                    +
   +   - parameters : char *First - pointer to a char                   +
   +                  char *Last  - pointer to a char                   +
   +                  Etype object - a generic type object              +
   +                                                                    +
   +   - default constructor                                            +
   +   - initializes object to default values                           +
   +   - dynamically allocates FirstName and LastName                   +
   +                                                                    +  
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
template<class Etype>
NamedItem<Etype>::NamedItem(char *First, char *Last, Etype object)
{
  FirstName = new String(First);

  LastName = new String(Last);

  Item = object;
}


/* +++++[ NamedItem(String First, String Last, Etype object) ]+++++++++++
   +                                                                    +
   +   - parameters : String First - A string                           + 
   +                  String Last - A string                            +       
   +                  Etype object - a generic type object              +
   +                                                                    +
   +   - default constructor                                            +
   +   - initializes object to default values                           +
   +   - dynamically allocates FirstName and LastName                   +
   +                                                                    +   
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
template<class Etype>  
NamedItem<Etype>::NamedItem(String First, String Last, Etype object) 
{
  FirstName = new String(First);

  LastName = new String(Last);

  Item = object;
}


/* +++++[  NamedItem(const NamedItem<Etype> &source) ]+++++++++++++++++++
   +                                                                    +
   +   - parameters : const NamedItem<Etype> &source                    +
   +            - a constant reference to an NamedItem object of Etype  +   
   +            - source is a previously allocated NamedItem<Etype> obj +
   +                                                                    +
   +   - copy constructor                                               +  
   +   - Initializes a object to a copy of source                       +
   +                                                                    +   
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
template<class Etype>
NamedItem<Etype>::NamedItem(const NamedItem<Etype> &source)
{
  FirstName = new String(*(source.FirstName));

  LastName = new String(*(source.LastName));

  Item = source.Item;
}

/* +++++[  ~NamedItem()  ]+++++++++++++++++++++++++++++++++++++++++++++++
   +                                                                    +
   +   - parameters : none                                              +   
   +                                                                    +
   +   - destructor - deletes dynamically allocated memory of           +
   +                  FirstName and LastName                            +  
   +                                                                    +   
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
template<class Etype>
NamedItem<Etype>::~NamedItem()
{
  delete  FirstName;
  delete  LastName;
}


/* +++++[  operator=(const NamedItem <Etype> &source)  ]+++++++++++++++++
   +                                                                    +
   +   - parameters : const NamedItem<Etype> &source                    +
   +                                                                    +
   +   - operator =   - used to make copies of NamedItem<Etype> objects + 
   +                                                                    +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
template<class Etype>
NamedItem<Etype> &NamedItem<Etype>::operator=(const NamedItem<Etype> &source)
{
  if (this != &source)
  {
    delete FirstName;
    delete LastName;

    FirstName = new String(*(source.FirstName));
    LastName = new String(*(source.LastName));


    Item = source.Item;
  }

  return *this;
}


/* +++++[ GetFirstName() ]+++++++++++++++++++++++++++++++++++++++++++++++
   +                                                                    +
   +   - parameters : none                                              +
   +                                                                    +
   +   - returns a constant reference to a string object                +
   +                                                                    +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
template<class Etype>
const String& NamedItem<Etype>::GetFirstName()
{
  return *FirstName;
}


/* +++++[ GetLastName() ]++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                                    +
   +   - parameters : none                                              +
   +                                                                    +
   +   - returns a constant reference to a string object                +
   +                                                                    +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
template<class Etype>
const String& NamedItem<Etype>::GetLastName()
{
  return *LastName;
}


/* +++++[ GetItem() ]++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                                    +
   +   - parameters : none                                              +
   +                                                                    +
   +   - returns a constant reference to a generic (Etype) type         +
   +                                                                    +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
template<class Etype>
const Etype & NamedItem<Etype>::GetItem()
{
  return Item;
}
